package provider.message.service.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import provider.message.dto.ProviderMessageQueueDto;
import provider.message.model.po.ProviderMessageQueue;
import provider.message.model.repository.ProviderMessageQueueRepos;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Lans
 * @date 2018-7-3 10:21
 */
@Service
public class ProviderMessageService {
    @Autowired
    private ProviderMessageQueueRepos providerMessageQueueRepos;

        private static Logger logger=LoggerFactory.getLogger(ProviderMessageService.class);

    public List<ProviderMessageQueueDto> getMessagesByType(String type, String appId, String providerId) {

        if(Lang.isEmpty(type)||Lang.isEmpty(appId)||Lang.isEmpty(providerId)){return  null;}
        else {
            List<ProviderMessageQueue> pmqs= new ArrayList<ProviderMessageQueue>();
                    pmqs= providerMessageQueueRepos.findByTypeAndAppIdAndProviderId(type, appId, providerId);
            List<ProviderMessageQueueDto> pmqds= new ArrayList<ProviderMessageQueueDto>();
            for (ProviderMessageQueue pmq:pmqs
                 ) {
                ProviderMessageQueueDto pmqd;
                pmqd=copyToDto(pmq);
                pmqds.add(pmqd);
            }
                    return pmqds;


        }
    }
    public List<ProviderMessageQueueDto> getMessagesByTypeAndProvider(String type,  String providerId) {

        if(Lang.isEmpty(type)||Lang.isEmpty(providerId)){return  null;}
        else {
            List<ProviderMessageQueue> pmqs= new ArrayList<ProviderMessageQueue>();
            pmqs= providerMessageQueueRepos.findByTypeAndProviderId(type, providerId);
            List<ProviderMessageQueueDto> pmqds= new ArrayList<ProviderMessageQueueDto>();
            for (ProviderMessageQueue pmq:pmqs
                    ) {
                ProviderMessageQueueDto pmqd;
                pmqd=copyToDto(pmq);
                pmqds.add(pmqd);
            }
            return pmqds;


        }
    }
    private  ProviderMessageQueueDto copyToDto(ProviderMessageQueue pmq){
        ProviderMessageQueueDto pmqd= new ProviderMessageQueueDto();
        pmqd.setAppId(pmq.getAppId());
        pmqd.setBusinessNo(pmq.getBusinessNo());
        pmqd.setId(pmq.getId());
        pmqd.setMessageContent(pmq.getMessageContent());
        pmqd.setProviderId(pmq.getProviderId());
        pmqd.setType(pmq.getType());
        pmqd.setTypeDescription(pmq.getTypeDescription());
        return  pmqd;
    }


    @Transactional(rollbackFor = Exception.class)
    public int deleteMessagesByIds(List<String> ids)  {
        //删除前先备份消息
        //TODO  考虑将历史消息备份到单独的日志文件，减轻数据库压力
        providerMessageQueueRepos.batchInsertByIds(ids);
        logger.info("{}条消息备份成功",ids.size());
       int i =  providerMessageQueueRepos.deleteByIdIn(ids);
        logger.info("{}条消息删除成功",i);
       return i;

    }

    @Transactional(rollbackFor = Exception.class)
    public int deleteMessagesByIdsAndProviderId(List<String> ids,String providerId)  {
        //删除前先备份消息
        //TODO  考虑将历史消息备份到单独的日志文件，减轻数据库压力
        providerMessageQueueRepos.batchInsertByIdsAndProviderId(ids,providerId);
        logger.info("{}条消息备份成功",ids.size());
        int i =  providerMessageQueueRepos.deleteByIdInAndProviderId(ids,providerId);
        logger.info("{}条消息删除成功",i);
        return i;

    }

    public void saveMessage(ProviderMessageQueueDto providerMessageQueueDto){
        ProviderMessageQueue providerMessageQueue = copyToProviderMessageQueue(providerMessageQueueDto);
        providerMessageQueueRepos.save(providerMessageQueue);
    }

    private ProviderMessageQueue copyToProviderMessageQueue(ProviderMessageQueueDto providerMessageQueueDto){
        ProviderMessageQueue providerMessageQueue = new ProviderMessageQueue();
        providerMessageQueue.setType(providerMessageQueueDto.getType());
        providerMessageQueue.setMessageContent(providerMessageQueueDto.getMessageContent());
        providerMessageQueue.setProviderId(providerMessageQueueDto.getProviderId());
        providerMessageQueue.setBusinessNo(providerMessageQueueDto.getBusinessNo());
        providerMessageQueue.setAppId(providerMessageQueueDto.getAppId());
        providerMessageQueue.setTypeDescription(providerMessageQueueDto.getTypeDescription());
        return providerMessageQueue;
    }

//    private ProviderObsoleteMesQueue copyToProviderObsoleteMesQueue(ProviderMessageQueue pmq){
//        ProviderObsoleteMesQueue pomq= new ProviderObsoleteMesQueue();
//        pomq.setAppId(pmq.getAppId());
//        pomq.setBusinessNo(pmq.getBusinessNo());
//        pomq.setId(pmq.getId());
//        pomq.setMessageContent(pmq.getMessageContent());
//        pomq.setProviderId(pmq.getProviderId());
//        pomq.setType(pmq.getType());
//        pomq.setTypeDescription(pmq.getTypeDescription());
//        return  pomq;
//    }
}
