/*
 * Decompiled with CFR 0.152.
 */
package provider.message.service.service;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import provider.message.dto.ProviderMessageQueueDto;
import provider.message.model.po.ProviderMessageQueue;
import provider.message.model.repository.ProviderMessageQueueRepos;
import utils.Lang;

@Service
public class ProviderMessageService {
    @Autowired
    private ProviderMessageQueueRepos providerMessageQueueRepos;
    private static Logger logger = LoggerFactory.getLogger(ProviderMessageService.class);

    public List<ProviderMessageQueueDto> getMessagesByType(String type, String appId, String providerId) {
        if (Lang.isEmpty((Object)type) || Lang.isEmpty((Object)appId) || Lang.isEmpty((Object)providerId)) {
            return null;
        }
        List pmqs = new ArrayList();
        pmqs = this.providerMessageQueueRepos.findByTypeAndAppIdAndProviderId(type, appId, providerId);
        ArrayList<ProviderMessageQueueDto> pmqds = new ArrayList<ProviderMessageQueueDto>();
        for (ProviderMessageQueue pmq : pmqs) {
            ProviderMessageQueueDto pmqd = this.copyToDto(pmq);
            pmqds.add(pmqd);
        }
        return pmqds;
    }

    public List<ProviderMessageQueueDto> getMessagesByTypeAndProvider(String type, String providerId) {
        if (Lang.isEmpty((Object)type) || Lang.isEmpty((Object)providerId)) {
            return null;
        }
        List pmqs = new ArrayList();
        pmqs = this.providerMessageQueueRepos.findByTypeAndProviderId(type, providerId);
        ArrayList<ProviderMessageQueueDto> pmqds = new ArrayList<ProviderMessageQueueDto>();
        for (ProviderMessageQueue pmq : pmqs) {
            ProviderMessageQueueDto pmqd = this.copyToDto(pmq);
            pmqds.add(pmqd);
        }
        return pmqds;
    }

    private ProviderMessageQueueDto copyToDto(ProviderMessageQueue pmq) {
        ProviderMessageQueueDto pmqd = new ProviderMessageQueueDto();
        pmqd.setAppId(pmq.getAppId());
        pmqd.setBusinessNo(pmq.getBusinessNo());
        pmqd.setId(pmq.getId());
        pmqd.setMessageContent(pmq.getMessageContent());
        pmqd.setProviderId(pmq.getProviderId());
        pmqd.setType(pmq.getType());
        pmqd.setTypeDescription(pmq.getTypeDescription());
        return pmqd;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteMessagesByIds(List<String> ids) {
        this.providerMessageQueueRepos.batchInsertByIds(ids);
        logger.info("{}\u6761\u6d88\u606f\u5907\u4efd\u6210\u529f", (Object)ids.size());
        int i = this.providerMessageQueueRepos.deleteByIdIn(ids);
        logger.info("{}\u6761\u6d88\u606f\u5220\u9664\u6210\u529f", (Object)i);
        return i;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteMessagesByIdsAndProviderId(List<String> ids, String providerId) {
        this.providerMessageQueueRepos.batchInsertByIdsAndProviderId(ids, providerId);
        logger.info("{}\u6761\u6d88\u606f\u5907\u4efd\u6210\u529f", (Object)ids.size());
        int i = this.providerMessageQueueRepos.deleteByIdInAndProviderId(ids, providerId);
        logger.info("{}\u6761\u6d88\u606f\u5220\u9664\u6210\u529f", (Object)i);
        return i;
    }

    public void saveMessage(ProviderMessageQueueDto providerMessageQueueDto) {
        ProviderMessageQueue providerMessageQueue = this.copyToProviderMessageQueue(providerMessageQueueDto);
        this.providerMessageQueueRepos.save((Object)providerMessageQueue);
    }

    private ProviderMessageQueue copyToProviderMessageQueue(ProviderMessageQueueDto providerMessageQueueDto) {
        ProviderMessageQueue providerMessageQueue = new ProviderMessageQueue();
        providerMessageQueue.setType(providerMessageQueueDto.getType());
        providerMessageQueue.setMessageContent(providerMessageQueueDto.getMessageContent());
        providerMessageQueue.setProviderId(providerMessageQueueDto.getProviderId());
        providerMessageQueue.setBusinessNo(providerMessageQueueDto.getBusinessNo());
        providerMessageQueue.setAppId(providerMessageQueueDto.getAppId());
        providerMessageQueue.setTypeDescription(providerMessageQueueDto.getTypeDescription());
        return providerMessageQueue;
    }
}

