package pool.api;

import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperAndLowerQueryDto;
import pool.dto.ProviderGoodsDto;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;


/**
 * 商品上下架接口接口API
 */
public interface GoodsUpperAndLowerApi {
    /**
     * 查看商品分类，分页
     */
    BaseResponse<PageVo<GoodsUpperAndLowerDto>> findGoodsUpperAndLowers(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto,int number,int size);

    /**
     * 批量上下架查询sku
     * @param goodsUpperAndLowerQueryDto
     * @return
     */
    BaseResponse<List<GoodsUpperAndLowerDto>>  findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto);

    /**
     * 查找供应商商品信息
     * @param storeId
     * @return
     */
    ProviderGoodsDto getGoodsDetailInfo(String sku,String storeId);

    /**
     * 商品信息补全
     * @param sku
     * @param storeId
     * @param individuaDescription
     * @return
     */
    BaseResponse editGoodsInfoCompletion(String sku,String storeId,String individuaDescription);

    /**
     * 统计导出商品总数
     * @param goodsUpperAndLowerQueryDto
     * @return
     */
    BaseResponse<Integer> findCountByGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto);
}
