package pool.api;

import localstore.dto.LocalStoreOrderVo;
import pool.dto.*;
import pool.vo.GoodsUpperAndLowerVo;
import pool.vo.ProviderGoodsVo;
import pool.vo.UpdateProviderGoodsVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

/**
 * 供应商对接
 * 商品接口
 * Created by zj on 2018/06/27.
 */
public interface ProviderGoodsApi {

    /**
     * 9.查询商品列表
     *
     * @param productQueryDto
     * @return
     */
    BaseResponse<PageVo<ProviderGoodsVo>> queryProviderGoodsPage(ProductQueryDto productQueryDto);

    /**
     * 10.查询单个商品
     *
     * @param sku
     * @return
     */
    BaseResponse<ProviderGoodsVo> queryProviderGoods(String sku, String storeId);

    /**
     * 11.创建商品
     *
     * @param providerGoodsDto
     * @return
     */
    BaseResponse<String> saveProviderGoods(ProviderGoodsDto providerGoodsDto);

    /**
     * 12.修改商品
     *
     * @param providerGoodsDto
     * @return
     */
    BaseResponse<String> updateProviderGoods(ProviderGoodsDto providerGoodsDto);

    /**
     * 13.商品上下架状态变更(可使用)
     *
     * @param providerGoodsStatusList
     * @return
     */
    BaseResponse modifyGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId);

    /**
     * 14.商品价格变更
     *
     * @param providerGoodsPriceList
     * @return
     */
    BaseResponse modifyGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId);

    /**
     * 15.商品库存变更
     *
     * @param providerGoodsStockList
     * @return
     */
    BaseResponse modifyGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId);

    /**
     * 16.批量查询多个商品（上下架状态，价格，库存）
     *
     * @param skus,storeIds
     * @return
     */
    BaseResponse queryGoods(List<String> skus, String storeId);

    /**
     * 17.预占库存接口
     *
     * @param localStoreOrderVo
     * @return
     */
    BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo);

    /**
     *  取消预占库存（取消订单 变更商品库存）
     * @param thrOrderNo
     * @param storedId
     * @return
     */
    BaseResponse cancelOccupyStock(String thrOrderNo, String storedId);

    /**
     * 设置优选或上下架
     * type 1 优选 2 不优选 3 上架 4 下架
     * <p>
     * taofeng
     */
    BaseResponse<List<String>> preferredOrIsUp(GoodsUpperAndLowerVo goodsUpperAndLowerVo);

    /**
     * 18.批量保存
     *
     * @param providerGoodsDtos
     * @return
     */
    BaseResponse<String> saveProviderProduct(ProductModelDto productModel,List<ProviderGoodsDto> providerGoodsDtos);

    /**
     * 19.批量更新
     *
     * @param
     * @return
     */
    public BaseResponse<List<ProviderGoodsDto>> updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo);

    /**
     * 20.查询单个商品
     *
     * @param sku
     * @return
     */
    ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId);

    List<ProviderGoodsDto> queryProviderGoodsDtoList(String sku, String storeId);

    public BaseResponse deleteProviderGoodsBatch(List<String> skus,String storeId);

    /**
     * zj
     * 根据modelSku storeId isDelete 获取商品
     */
    public List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku,String storeId,Boolean isDelete);

    /**
     * zj
     * 修改单一商品的brandName，brandId
     */
    public void updateBrandInfo(String id,String brandName,String brandId);
}
