package pool.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author luoxianwei
* @date 2018/5/8 
*/
@Data
public class GoodsUpperAndLowerQueryDto implements Serializable{
    /**
     * 分类Id
     */
    private String productCategoryId;
    /**
     * 来源渠道(合作伙伴)
     */
    private String orgCode;
    /**
     * 供应商sku
     */
    private String sku;
    /**
     * 供应商
     */
    private String storeId;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 上下架状态
     */
    private String isUp;
    /**
     * 是否优选
     */
    private String isPreferred;
    /**
     * 品牌
     */
    private String brandIds;
    /**
     * 协议价起始值
     */
    private BigDecimal startCostPrice;
    /**
     * 协议价结束值
     */
    private BigDecimal endCostPrice;
    /**
     * 销售价起始值
     */
    private BigDecimal startSalePrice;
    /**
     * 销售价结束值
     */
    private BigDecimal endSalePrice;
    /**
     * 费率起始值
     */
    private BigDecimal startRateModeRate;
    /**
     * 费率结束值
     */
    private BigDecimal endRateModeRate;
    /**
     * 协议折扣率起始值
     */
    private BigDecimal startAgreementDiscountRate;
    /**
     * 协议折扣率结束值
     */
    private BigDecimal endAgreementDiscountRate;
    /**
     * 实时折扣率起始值
     */
    private BigDecimal startRealTimeDiscountRate;
    /**
     * 实时折扣率结束值
     */
    private BigDecimal endRealTimeDiscountRate;

    /**
     * 排序参数
     */
    private String sortParam;

    /**
     * 排序值
     */
    private String sortValue;

}
