package pool.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * taofeng
 */
@Data
public class ProviderProductFashionDto implements Serializable {

    private String id;

    /**
     * 商品编码
     */
    private String sku;

    /**
     * 供应商id
     */
    private String storeId;

    /**
     * 模型id
     */
    private ProviderProductDto providerProduct;

    /**
     * 协议价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 售价
     */
    private BigDecimal salePrice;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 库存
     */
    private Integer stockCount;

    /**
     * 商品个性化描述
     */
    private String individuaDescription;

    /**
     * 商品图片
     */
    private List<ProviderProductFashionPictureDto> pics;

    private String modelSku;        //模型sku
    private String weight;      //重量
    private String productArea;     //产地
    private String upc;         //条形码
    private String saleUnit;        //销售单位
    private String introduction;        //详情介绍
    private String goodsDetail;         //详情
    private String param;           //规格参数
    private String wareQD;      //包装清单
    private String afterSaleDetails;        //售后详情
    private Date pushDownDate;      //下架时间
    private Date pushUpDate;        //上架时间
    private Boolean isRecommend;    //是否为推荐商品
    private Boolean isSpecial;     //是否为特价商品
    private Boolean isHotSale;      //是否为热销商品
    private Boolean isNewProduct;       //是否为新产品
    private Integer providerSaleStatus;          //1已上架 0已下架 // 数据库 商品的状态:0 已下架1已上架 2审核通过 3审核不通过 4默认  (废弃:0 待审核 默认1审核不通过 2 审核通过 3已上架 4已下架)
    private Boolean judgeFactoryFlag;          //是否产家配送
    private String remark;              //备注
    private Integer postSalePolicy;        //是否支持售后政策 0:不支持
    private Integer invoiceType;       //是否支持开具发票 1：支持增票、普票 2 支持增票，不支持普票 3 不支持增票，支持普票 4 都不支持

    /**
     * 新增字段
     */
    private String categoryName;              //分类名称
    private String provideName;              //供应商名称
    private String brandName;             //商品品牌
    private String categoryId;              //分类id

    /**
     * 费率
     */
    private BigDecimal rateModeRate;

    /**
     * 实时折扣率
     */
    private BigDecimal realTimeDiscountRate;

    /**
     * 协议折扣率
     */
    private BigDecimal agreementDiscountRate;

    /**
     * 商品Id
     */
    private String brandId;

    /**
     * 规格参数组合
     */
    private List<ProviderGoodsSpecificationDto> providerGoodsSpecifications;
}
