package pool.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
@Entity
@Table(name = "address"
        ,indexes = {@Index(name="idx_address_parent_id",columnList = "parent_id"),
        @Index(name="idx_address_level_type",columnList = "level_type")
})
@Data
public class ProviderAddress implements Serializable {
    private static final long serialVersionUID = 1504899344873026284L;
    @Id
    @Column(length = 36)
    private String id;
    @Column(name="parent_id")
    private String parentId;
    private String name;
    @Column(name="short_name")
    private String shortName;
    @Column(name="level_type")
    private String levelType;
}
