package pool.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import pool.model.base.BaseDomain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
@Data
public class ProviderGoodsMqLog extends BaseDomain {

    public final static String UPDATEPRICE = "updatePrice";
    public final static String PRODUCTDELETE = "productDelete";
    public final static String PRODUCTADD = "productAdd";
    public final static String PRODUCTDETAIL = "productDetail";
    public final static String UPDATESKUSTATUS = "updateSkuStatus";

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36, name = "id")
    private String id;

    //操作类型
    private String type;

    private String sku;

    //供应商名
    private String providername;

    private String messageId;

    private String remark;

}
