package pool.model;

import org.hibernate.annotations.GenericGenerator;
import pool.model.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by Jian on 2018-8-29.
 */
@Entity
@Table(indexes = {
        @Index(name = "IDX_SPEC_STAN_CODE", columnList = "standardCode")
})
public class ProviderGoodsSpecification extends BaseDomain implements Serializable {

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;
    //规格代码
    private String standardCode;
    //规格值
    private String value;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "PROVIDER_PRODUCT_FASHION_ID",foreignKey = @ForeignKey(name = "fk_provider_g"))
    private ProviderProductFashion providerProductFashion;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ProviderProductFashion getProviderProductFashion() {
        return providerProductFashion;
    }

    public void setProviderProductFashion(ProviderProductFashion providerProductFashion) {
        this.providerProductFashion = providerProductFashion;
    }

    @Override
    public String toString() {
        return "ProviderGoodsSpecification{" +
                "id='" + id + '\'' +
                ", standardCode='" + standardCode + '\'' +
                ", value='" + value + '\'' +
                ", providerProductFashion=" + providerProductFashion +
                '}';
    }
}
