package pool.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import pool.model.base.BaseDomain;

import javax.persistence.*;

/**
 * 商品模型
 * 实体类
 * CREATED BY ZJ 2018/07/03
 */
@Entity
@Table(name="PROVIDER_PRODUCT",
        indexes = {@Index(name="idx_product_model_sku",columnList = "model_sku"),
        @Index(name="idx_product_model_store_id",columnList = "store_id")
    })
@Data
public class ProviderProduct extends BaseDomain{
    private static final long serialVersionUID = -903809133697589962L;
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36,name="id")
    private String modelId;
    @Column(name="model_sku")
    private String modelSku;
    @Column(name="model_name")
    private String name;
    @Column(name="store_id")
    private String storeId;
    @Column(name="product_category_id")
    private String categoryId;
    @Column(name="type")
    private String type;
    @Column(name="audit_status")
    private String auditStatus;
    @Column(name="updown_status")
    private String upDownStatus;
    @Column(name="provider_product_brand_id")
    private String brandId;
    @Column(name="product_brand_id")
    private String productBrandId;
    @Column(name="provider_product_category_id")
    private String providerProductCategoryId;
}
