package pool.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import pool.model.base.BaseDomain;

import javax.persistence.*;

/**
 * 供应商对接：商品品牌
 * 实体类
 * CREATED BY ZJ 2018/07/02
 */
@Entity
@Table(name="PROVIDER_PRODUCT_BRAND",indexes = {@Index(name="idx_brand_store_id",columnList = "store_id")})
@Data
public class ProviderProductBrand extends BaseDomain {
    private static final long serialVersionUID = 7650656223251791985L;
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36,name="id")
    private String id;       //id
    @Column(name = "description", columnDefinition = "clob")
    @Type(type = "text")
    private String description; //描述
    @Column(name="is_carefully_chosen")
    private Boolean isCarefullyChosen; //是否为精品商品
    @Column(name="is_disable")
    private Boolean isDisable = false;      //是否禁用
    @Column(name="name")
    private String name;        //品牌名称
    @Column(name="show_index")
    private Integer showIndex;      //排序 保留字段
    @Column(name="simple_name")
    private String simpleName;      //简称
    @Column(name="websites_url")
    private String websitesUrl;        //站点地址
    @Column(name="store_id")
    private String storeId;         //品牌来源，供应商id
    @Transient
    private String storeName;  //  店铺名称
    @Column(name="category_id")
    private String categoryId;     //分类id(不需要)
    @Column(name="match_flag")
    private String matchFlag;    //是否匹配成功
    @Column(name="match_source")
    private String matchSource; //匹配来源
    @Column(name="product_brand_id")
    private String productBrandId; //标准化品牌id
    @Column(name="product_brand_name")
    private String productBrandName; //标准化品牌名称
    @Column(name="provider_brand_first_letter")
    private String firstLetter;  //供应商品牌首字母
}
