package pool.model;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import pool.model.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author Jian
 * @date 2018-8-27
 */
@Entity
@Table()
public class ProviderProductCategory extends BaseDomain implements Serializable {


    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;

    /**
     * 类型名称
     */
    @Column(name = "name", nullable = false)
    private String name;


    /**
     * 排序值
     */
    @Column(name = "show_index", nullable = true)
    private Integer showIndex;

    /**
     * 关键值
     */
    @Column(name = "keywords", columnDefinition = "clob")
    @Type(type = "text")
    private String keywords;

    /**
     * 描述
     */
    @Column(name = "description", columnDefinition = "clob")
    @Type(type = "text")
    private String description;

    /**
     * 标题
     */
    @Column(name = "title")
    private String title;

    /**
     * 所属层级，用于列表排序
     */
    @Column(name = "layer_index")
    private Integer layerIndex;

    /**
     * 预留字段，可记录第三方分级id
     */
    private String code;

    /**
     * 分类是否上架 0 1
     */
    private Integer state;

    /**
     * 分类类型，该字段一级分类有效，用于首页同类商品分类合并展示
     */
    private Integer categoryType;


    /**
     * 来源code
     */
    @Column(name = "source_code")
    private String sourceCode;

    @Column(name = "CATEGORY_REMARKS")
    private String categoryRemarks;

    /**
     * 来源
     * online  线上同步
     * line 线下
     */
    private String categorySource;

    private String storeId;

    private String productCategoryId;



    /**
     * 子类型
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "parent_id", foreignKey = @ForeignKey(name = "PROVIDER_CATEGORY_FK"))
    // @JsonBackReference
    private ProviderProductCategory parent;

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
    //   @JsonManagedReference
    private List<ProviderProductCategory> child;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getLayerIndex() {
        return layerIndex;
    }

    public void setLayerIndex(Integer layerIndex) {
        this.layerIndex = layerIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(Integer categoryType) {
        this.categoryType = categoryType;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getCategoryRemarks() {
        return categoryRemarks;
    }

    public void setCategoryRemarks(String categoryRemarks) {
        this.categoryRemarks = categoryRemarks;
    }

    public String getCategorySource() {
        return categorySource;
    }

    public void setCategorySource(String categorySource) {
        this.categorySource = categorySource;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getProductCategoryId() {
        return productCategoryId;
    }

    public void setProductCategoryId(String productCategoryId) {
        this.productCategoryId = productCategoryId;
    }

    public ProviderProductCategory getParent() {
        return parent;
    }

    public void setParent(ProviderProductCategory parent) {
        this.parent = parent;
    }

    public List<ProviderProductCategory> getChild() {
        return child;
    }

    public void setChild(List<ProviderProductCategory> child) {
        this.child = child;
    }
}
