package pool.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import pool.model.base.BaseDomain;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品图片
 * 实体类
 * CREATED BY ZJ 2018/07/04
 */
@Entity
@Table(name = "PROVIDER_PRODUCT_FASHION",
        indexes = {@Index(name = "idx_PROVIDER_PRODUCT_FASHION_sku", columnList = "sku"),
                @Index(name = "idx_PROVIDER_PRODUCT_FASHION_store_id", columnList = "store_id")}
)
@Data
public class ProviderProductFashion extends BaseDomain {
    // TODO 类名称与表名称 一致
    private static final long serialVersionUID = -7185841660821033769L;
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36, name = "id")
    private String id;
    @Column(name = "sku")
    private String sku;             //商品编码
    @Column(name = "model_sku")
    private String modelSku;        //模型sku
    @Column(name = "weight")
    private String weight;      //重量
    @Column(name = "name")
    private String name;        //商品名称
    @Column(name = "product_area")
    private String productArea;     //产地
    @Column(name = "upc")
    private String upc;         //条形码
    @Column(name = "sale_unit")
    private String saleUnit;        //销售单位
    @Column(name = "introduction", columnDefinition = "clob")
    @Type(type = "text")
    private String introduction;        //详情介绍
    @Column(name = "goods_details", columnDefinition = "clob")
    @Type(type = "text")
    private String goodsDetail;         //详情
    @Column(name = "param", columnDefinition = "clob")
    @Type(type = "text")
    private String param;           //规格参数
    @Column(name = "wareQD", columnDefinition = "clob")
    @Type(type = "text")
    private String wareQD;      //包装清单

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "providerProductFashion", cascade = CascadeType.ALL)
    private List<ProviderProductFashionPicture> pics;                //商品图片
    // todo 库存，价格的变化会影响
    @Column(name = "cost_price")
    private BigDecimal costPrice;       //协议价
    @Column(name = "market_price")
    private BigDecimal marketPrice;     //市场价
    @Column(name = "sale_price")
    private BigDecimal salePrice;       //售价
    @Column(name = "stock_count")
    private Integer stockCount;         //库存

    @Column(name = "after_sale_details", columnDefinition = "clob")
    @Type(type = "text")
    private String afterSaleDetails;        //售后详情
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "PROVIDER_PRODUCT_ID")
    private ProviderProduct providerProduct;  //模型id

    @Column(name = "STORE_ID")
    private String storeId;     //供应商id
    @Column(name = "PUSH_DOWN_DATE")
    private Date pushDownDate;      //下架时间
    @Column(name = "PUSH_UP_DATE")
    private Date pushUpDate;        //上架时间
    @Column(name = "IS_RECOMMEND")
    private Boolean isRecommend;    //是否为推荐商品
    @Column(name = "IS_SPECIAL")
    private Boolean isSpecial;     //是否为特价商品
    @Column(name = "IS_HOTSALE")
    private Boolean isHotSale;      //是否为热销商品
    @Column(name = "IS_NEW_PRODUCT")
    private Boolean isNewProduct;       //是否为新产品

    @Column(name = "provider_sale_status")
    private Integer providerSaleStatus;          //1已上架 0已下架 // 数据库 商品的状态:0 已下架1已上架 2审核通过 3审核不通过 4默认  (废弃:0 待审核 默认1审核不通过 2 审核通过 3已上架 4已下架)
    @Column(name = "judge_factory_flag")
    private Boolean judgeFactoryFlag;          //是否产家配送
    @Column(name = "remark")
    private String remark;              //备注
    @Column(name = "post_sale_policy")
    private Integer postSalePolicy;        //是否支持售后政策 0:不支持
    @Column(name = "invoice_type")
    private Integer invoiceType;       //是否支持开具发票 1：支持增票、普票 2 支持增票，不支持普票 3 不支持增票，支持普票 4 都不支持

    /**
     * 新增字段
     */
    @Column(name = "CATEGORY_NAME")
    private String categoryName;              //分类名称
    @Column(name = "PROVIDER_NAME")//修改
    private String provideName;              //供应商名称
    @Column(name = "brand_name")
    private String brandName;             //商品品牌
    @Column(name = "CATEGORY_ID")
    private String categoryId;              //分类id
    @Column(name = "INDIVIDUA_DESCRIPTION")
    private String individuaDescription;    //商品个性化描述


    @Override
    public String toString() {
        return this.id;
    }

    /**
     * 费率
     */
    @Column(name = "RATE_MODE_RATE")
    private BigDecimal rateModeRate;

    /**
     * 实时折扣率
     */
    @Column(name = "REAL_TIME_DISCOUNT_RATE")
    private BigDecimal realTimeDiscountRate;

    /**
     * 协议折扣率
     */
    @Column(name = "AGREEMENT_DISCOUNT_RATE")
    private BigDecimal agreementDiscountRate;

    /**
     * 商品Id
     */
    @Column(name = "BRAND_ID")
    private String brandId;



    /**
     * 商品品牌
     */
//    @Column(name = "BRAND_NAME")
//    private String goodsBrand;


    /**
     * 规格参数组合
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "providerProductFashion", cascade = CascadeType.ALL)
    private List<ProviderGoodsSpecification> providerGoodsSpecifications;
}
