package pool.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 商品图片
 * 实体类
 * CREATED BY ZJ 2018/07/02
 */
@Data
@Entity
@Table(name="PROVIDER_PRO_FASHION_PICTURE",indexes = {@Index(name="idx_picture_goods_id",columnList = "PROVIDER_PRODUCT_FASHION_id")})
public class ProviderProductFashionPicture implements Serializable{
    private static final long serialVersionUID = 325508864005984506L;
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36,name="id")
    private String id;
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name="PROVIDER_PRODUCT_FASHION_id",foreignKey = @ForeignKey(name = "fk_PROVIDER_PRODUCT_FASHION"))
    private ProviderProductFashion providerProductFashion;  //供应商商品
    @Column(name="IS_PRIMARY")
    private Boolean isPrimary;          //1：主图 0：附图
    @Column(name="ORDERSORT")
    private Integer orderSort;      //图片排序顺序
    @Column(name="path")
    private String path;            //地址，图片路径 ，完整的图片url，包含域名
    @Column(name="type")
    private String  type;           //类别（0 方图  1 长图）
    @Column(name="features")
    private String features;        //特征
    @Column(name="position")
    private String position;        //位置
}
