package pool.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import pool.model.ProviderProductBrand;

import java.util.Date;
import java.util.List;


public interface ProviderProductBrandRepos extends JpaRepository<ProviderProductBrand,String>,JpaSpecificationExecutor<ProviderProductBrand> {

    ProviderProductBrand findByNameAndStoreId(String name, String storeId);

    @Query("select count(providerProdctBrand.id) from ProviderProductBrand providerProdctBrand where providerProdctBrand.productBrandId = ?1 and providerProdctBrand.isDelete = 0")
    int findByProductBrandId(String productBrandId);

    ProviderProductBrand findByIdAndIsDelete(String brandId, boolean isdelete);

//    ProviderProductBrand findByNameAndStoreIdAndIsDelete(String name, String storeId, boolean isDelete);

    List<ProviderProductBrand> findByNameAndStoreIdAndIsDelete(String name, String storeId, boolean isDelete);


    @Modifying(clearAutomatically = true)
    @Query("update ProviderProductBrand p set p.productBrandName = ?2 where p.productBrandId =?1 and p.isDelete=0 ")
    @Transactional
    void updateProviderBrandMappingInfo(String productBrandId, String productBrandName);

}
