package pool.model.repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pool.model.ProviderProductFashion;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public interface ProviderProductFashionRepos extends JpaRepository<ProviderProductFashion, String>, JpaSpecificationExecutor<ProviderProductFashion> {

    ProviderProductFashion findOneBySku(String sku);  //根据编号查询商品

    List<ProviderProductFashion> findBySku(String sku);

    ProviderProductFashion findOneBySkuAndStoreId(String sku, String storeId);


//    @Query("select p from PROVIDER_PRODUCT_FASHION p where p.sku in ?1 and p.storeId=?2")
//    List<ProviderProductFashion> findBySkusAnAndStoreId(List<String> skus,String storeId);
//
//    @Query(" update PROVIDER_PRODUCT_FASHION p set p.stockCount =p.stockCount-?1 where p.sku=?1 and p.storeId=?2 ")
//    int updateCountBySkuAndSotreId(String sku, String storeId,Integer count);

    @Modifying(clearAutomatically = true)
    @Query("update ProviderProductFashion p set p.costPrice = ?2, p.salePrice = ?2, p.marketPrice = ?3, p.lastUpdated = ?4 where p.sku = ?1 and p.storeId=?5")
    @Transactional
    int updatePriceBySku(String sku, BigDecimal costPrice, BigDecimal marketPrice, Date date, String storeId);

    //isUp 1已上架 0已下架
    @Modifying(clearAutomatically = true)
    @Query("update ProviderProductFashion p set p.providerSaleStatus = ?2, p.isDelete = ?3, p.lastUpdated = ?4 where p.sku = ?1")
    @Transactional
    int updateStateBySku(String sku, int isUp, Boolean isDelete, Date lastUpdated);

    @Query("select p from ProviderProductFashion p where p.sku in (?1) and p.storeId=?2")
    List<ProviderProductFashion> findBySkusAndStoreId(List<String> skus, String storeId);

    @Query(value = "update PROVIDER_PRODUCT_FASHION p set p.STOCK_COUNT =p.STOCK_COUNT-?3 where p.STOCK_COUNT>=?3 and p.STORE_ID=?2 and p.SKU=?1 ", nativeQuery = true)
    @Modifying(clearAutomatically = true)
    @Transactional
    int updateCountBySkuAndSotreId(String sku, String storeId, Integer count);

    @Query(value = "update PROVIDER_PRODUCT_FASHION p set p.STOCK_COUNT = p.STOCK_COUNT+?3 where p.STORE_ID=?2 and p.SKU=?1 ", nativeQuery = true)
    @Modifying(clearAutomatically = true)
    @Transactional
    int updateAddCountBySkuAndSotreId(String sku, String storeId, Integer count);

    /**
     * 分页查询供应商的商品的信息
     */
    Page<ProviderProductFashion> findAll(Pageable pageable);

    @Modifying(clearAutomatically = true)
    @Query("update ProviderProductFashion g set g.providerSaleStatus=?2,g.isDelete=?3,g.lastUpdated=?5 where g.sku in (?1) and g.storeId=?4")
    @Transactional
    int deleteProviderGoodsBatch(List<String> skuIds, Integer state, Boolean isDelete, String storeId, Date lastUpdated);

    List<ProviderProductFashion> findBySkuAndStoreIdAndIsDelete(String sku, String storeId, boolean isDelete);

    List<ProviderProductFashion> findByModelSkuAndStoreId(String sku, String storeId);

    @Query("select p.modelSku from ProviderProductFashion p where p.sku = ?1 and p.storeId = ?2 and p.isDelete = false ")
    String findModelSku(String sku, String storeId);
	@Modifying(clearAutomatically = true)
    @Query("update ProviderProductFashion pg set pg.brandName = ?2 ,pg.brandId = ?3 where pg.id = ?1 and pg.isDelete= '0' ")
    @Transactional
    void updateBrandInfo(String id,String brandName,String brandId);


    @Modifying(clearAutomatically = true)
    @Query("update ProviderProductFashion p set p.providerSaleStatus = ?2, p.lastUpdated = ?3 where p.sku in (?1) and p.storeId=?4 ")
    @Transactional
    void updateStateBySkuBatch(List<String> sku, int isUp, Date lastUpdated,String storeId);

}
