package pool.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import pool.model.ProviderProduct;

import java.util.List;

public interface ProviderProductRepos extends JpaRepository<ProviderProduct, String>, JpaSpecificationExecutor<ProviderProduct> {

    ProviderProduct findOneByModelIdAndStoreIdAndIsDelete(String modelid, String storeId, boolean isDelete);

    ProviderProduct findOneByModelSkuAndStoreId(String modelSku, String storeId);

    ProviderProduct findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, boolean isDelete);

    List<ProviderProduct> findByBrandIdAndIsDelete(String providerBrandId,boolean isDelete);
}
