package pool.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
@Aspect
public class ProviderPoolLogAspect {

    @Pointcut("execution(* pool.service.apiImpl..*.*(..)) && !execution(* pool.service.apiImpl.providermanager.brandmanager..*.*(..))")
    public void logService(){
    }
    @Before("logService()")
    public void beforeLog(JoinPoint joinPoint) throws Exception{
        Logger logger = LoggerFactory.getLogger(Class.forName(joinPoint.getSignature().getDeclaringTypeName()));
        String class_method = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName();
        logger.info("调用接口："+class_method);
        logger.info("before:------------------requestParams : " + Arrays.toString(joinPoint.getArgs()));
    }
    @AfterReturning(returning = "ret",pointcut = "logService()")
    public void afterLog(JoinPoint joinPoint,Object ret) throws Exception{
        Logger logger = LoggerFactory.getLogger(Class.forName(joinPoint.getSignature().getDeclaringTypeName()));
        String str = JSON.toJSONString(ret, SerializerFeature.WriteMapNullValue);
        logger.info("after:------------------responseBody : "+str);
    }
}
