package pool.config;

import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sinomall.config.common.ActiveMqConfig;
import sinomall.config.common.CommonMotanConfig;
import sinomall.config.common.CommonRedisConfig;
import sinomall.config.service.CommonServiceMotanConfig;
import utils.Lang;
//import sinomall.config.web.CommonWebMotanConfig;

/**
 * @author torvalds on 2018/6/27 14:06.
 * @version 1.0
 */
@ImportAutoConfiguration({
        CommonMotanConfig.class,
//        CommonWebMotanConfig.class,
        CommonServiceMotanConfig.class,
        ActiveMqConfig.class
})
@Configuration
public class AutoConfig {

    @Bean(name = "motanClientBasicConfig")
    public BasicRefererConfigBean baseRefererConfig() {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        // config.setGroup("sinomall");
        config.setGroup("sinomall");
        config.setAccessLog(false);
        ///config.setModule("motan-demo-rpc");
        //config.setApplication("myMotanDemo");
        config.setRegistry("registry");
        config.setCheck(false);
        //  config.setAccessLog(false);
        //config.setRetries(2);
        config.setRequestTimeout(60*1000);
        config.setThrowException(true);
        config.setDefault(true);
        return config;
    }

}
