package pool.config;

import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import utils.sql.QueryByPage;
import utils.sql.JdbcTemplatePage;

@Configuration
@EntityScan(basePackages={"pool.model"})
@EnableJpaRepositories(basePackages={"pool.model.repository"})
public class JpaConfig {
    @Bean
    JdbcTemplatePage jdbcTemplatePage(){
        return new JdbcTemplatePage();
    }
    @Bean
    public QueryByPage queryByPage(){
        QueryByPage queryByPage = new QueryByPage();
        return queryByPage;
    }}
