package pool.config;

import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pool.dto.PicDto;
import pool.dto.ProviderGoodsDto;
//import pool.model.Category;
import pool.model.ProviderProductFashionPicture;
import pool.model.ProviderProductFashion;
import pool.vo.FashionPicVo;
import pool.vo.ProviderGoodsVo;

import java.util.LinkedList;
import java.util.List;

@Configuration
public class OrikaConfig {
    @Bean
    MapperFactory mapperFactory() {
        MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
        List<ClassMapBuilder> builders = new LinkedList<>();
//        builders.add(mapperFactory.classMap(Category.class, CategoryVo.class));
        builders.add(mapperFactory.classMap(ProviderProductFashion.class, ProviderGoodsVo.class).field("id","productId").field("pics","fashionPics").field("providerSaleStatus","status"));
        builders.add(mapperFactory.classMap(ProviderProductFashion.class, ProviderGoodsDto.class).field("providerSaleStatus","status"));
        builders.add(mapperFactory.classMap(ProviderProductFashionPicture.class, PicDto.class));
        builders.add(mapperFactory.classMap(ProviderProductFashionPicture.class, FashionPicVo.class));

        for (ClassMapBuilder builder : builders) {
            builder.byDefault().register();
        }
        return mapperFactory;
    }

    @Bean
    MapperFacade mapperFacade() {
        MapperFacade mapper = mapperFactory().getMapperFacade();
        return mapper;
    }


}
