package pool.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pool.api.ProductCategoryApi;
import pool.service.service.CategoryService;
import pool.vo.ProviderProductCategoryVo;

import java.util.List;

@MotanService
public class CategoryApiImpl implements ProductCategoryApi {

    @Autowired
    CategoryService categoryService;

    private static final Logger logger = LoggerFactory.getLogger(CategoryApiImpl.class);

//    @Override
//    public BaseResponse<PageVo<CategoryVo>> findByCategoryQuery(CategoryQueryDto categoryDto) {
//
//        BaseResponse baseResponse = categoryService.findCategories(categoryDto);
//
//        return baseResponse;
//    }

    @Override
    public List<ProviderProductCategoryVo> findProviderCategoryByCodeAndStoreId(String code, String storeId) {
        return categoryService.findProviderCategoryByCodeAndStoreId(code,storeId);
    }


}
