package pool.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.ProductFashionApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pool.api.GoodsUpperAndLowerApi;
import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperAndLowerQueryDto;
import pool.dto.ProviderGoodsDto;
import pool.service.service.GoodsUpperAndLowerService;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

@MotanService
public class GoodsUpperAndLowerApiImpl implements GoodsUpperAndLowerApi {

    @Autowired
    private GoodsUpperAndLowerService goodsUpperAndLowerService;

    private static final Logger logger = LoggerFactory.getLogger(GoodsUpperAndLowerApiImpl.class);

    @Override
    public BaseResponse<PageVo<GoodsUpperAndLowerDto>> findGoodsUpperAndLowers(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto,int number,int size) {
        return goodsUpperAndLowerService.findGoodsUpperAndLowers(goodsUpperAndLowerQueryDto, number, size);
    }

    @Override
    public BaseResponse<List<GoodsUpperAndLowerDto>>  findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        return goodsUpperAndLowerService.findGoodsUpperAndLowersByQuery(goodsUpperAndLowerQueryDto);
    }

    @Override
    public ProviderGoodsDto getGoodsDetailInfo(String sku,String storeId) {
        return goodsUpperAndLowerService.getGoodsDetailInfo(sku,storeId);
    }

    @Override
    public BaseResponse editGoodsInfoCompletion(String sku,String storeId,String individuaDescription) {
        return goodsUpperAndLowerService.editGoodsInfoCompletion(sku,storeId,individuaDescription);
    }

    @Override
    public BaseResponse<Integer> findCountByGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        return goodsUpperAndLowerService.findCountByGoodsUpperAndLowersByQuery(goodsUpperAndLowerQueryDto);
    }
}
