package pool.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pool.api.ProviderAddressApi;
import pool.model.ProviderAddress;
import pool.service.service.ProviderAddressService;
import sinomall.global.common.response.BaseResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@MotanService
public class ProviderAddressApiImpl implements ProviderAddressApi {
    @Autowired
    private ProviderAddressService providerAddressService;

    private static final Logger logger = LoggerFactory.getLogger(ProviderAddressApiImpl.class);

    public BaseResponse findAddressByParentIdAndLevelType(String parentId,String levelType){

        List<ProviderAddress> providerAddressList = providerAddressService.findAddressByParentIdAndLevelType(parentId,levelType);
        //对外数据封装：
        Map<String,Object> map =new HashMap();
        Map<String,String> mapResult = new TreeMap<>();
        for(ProviderAddress e:providerAddressList){
            mapResult.put(e.getName(),e.getId());
        }
        if("1".equals(levelType)){
            map.put("province",mapResult);
        }else if("2".equals(levelType)){
            map.put("city",mapResult);
        }else if("3".equals(levelType)){
            map.put("county",mapResult);
        }else if("4".equals(levelType)){
            map.put("town",mapResult);
        }
        BaseResponse baseResponse = new BaseResponse(true, "操作成功", map, "0000");

       return baseResponse;
    }
}
