package pool.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pool.api.ProviderProductBrandApi;
import pool.dto.BrandDto;
import pool.dto.BrandQueryDto;
import pool.service.service.BrandService;
import pool.vo.BrandVo;
import pool.vo.ProviderProductBrandVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;
import java.util.Map;
@MotanService
public class ProviderBrandApiImpl implements ProviderProductBrandApi {
    private static final Logger logger = LoggerFactory.getLogger(ProviderBrandApiImpl.class);

    @Autowired
    private BrandService brandService;
    @Override
    public BaseResponse<Map<String,String>> saveBrand(BrandDto brandDto){

        BaseResponse baseResponse = brandService.saveBrand(brandDto);

        return baseResponse;
    }
    @Override
    public BaseResponse<PageVo<BrandVo>> queryBrands(BrandQueryDto brandQueryDto){

        BaseResponse<PageVo<BrandVo>> baseResponse = brandService.queryBrands(brandQueryDto);

        return baseResponse;
    }
    @Override
    public BaseResponse<String> deleteBrand(String brandId){

        BaseResponse<String> baseResponse = brandService.deleteBrand(brandId);

        return baseResponse;
    }

    @Override
    public ProviderProductBrandVo findBrandByNameAndStoreId(String brandName, String storeId) {
        return brandService.findBrandByNameAndStoreId(brandName,storeId);
    }
}
