package pool.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import localstore.dto.LocalStoreOrderVo;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pool.api.ProviderGoodsApi;
import pool.dto.*;
import pool.service.service.GoodsAutosyncFilterService;
import pool.service.service.ProviderGoodsService;
import pool.vo.GoodsUpperAndLowerVo;
import pool.vo.ProviderGoodsVo;
import pool.vo.UpdateProviderGoodsVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.PageVo;

import java.util.List;

@Slf4j
@MotanService
public class ProviderGoodsApiImpl implements ProviderGoodsApi {

    private static int LIMIT = 10000;

    @Autowired
    private ProviderGoodsService providerGoodsService;

    @Autowired
    private ProviderGoodsService providerProductService;

    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;

    private static final Logger logger = LoggerFactory.getLogger(ProviderGoodsApiImpl.class);

    @Override
    public BaseResponse<PageVo<ProviderGoodsVo>> queryProviderGoodsPage(ProductQueryDto productQueryDto) {
        logger.info("第三方供应商对接接口，查询商品列表接口输入参数：{}", JSON.toJSONString(productQueryDto, SerializerFeature.WriteMapNullValue));
        BaseResponse baseResponse = providerGoodsService.queryProviderGoodsPage(productQueryDto);
        logger.info("第三方供应商对接接口，查询商品列表接口输出参数：{}", JSON.toJSONString(baseResponse, SerializerFeature.WriteMapNullValue));
        return baseResponse;
    }

    @Override
    public BaseResponse<ProviderGoodsVo> queryProviderGoods(String sku, String storeId) {
        logger.info("第三方供应商对接接口，查询单个商品接口输入参数：{},{}", sku, storeId);
        BaseResponse baseResponse = providerGoodsService.queryProviderGoods(sku, storeId);
        logger.info("第三方供应商对接接口，查询单个商品接口输出参数：{}", JSON.toJSONString(baseResponse, SerializerFeature.WriteMapNullValue));
        return baseResponse;
    }

    @Override
    public BaseResponse<String> saveProviderGoods(ProviderGoodsDto providerGoodsDto) {
        logger.info("第三方供应商对接接口，保存商品接口输入参数：{}", JSON.toJSONString(providerGoodsDto, SerializerFeature.WriteMapNullValue));
        BaseResponse baseResponse = providerGoodsService.saveProviderGoods(providerGoodsDto);
        logger.info("第三方供应商对接接口，保存商品接口输出参数：{}", JSON.toJSONString(baseResponse, SerializerFeature.WriteMapNullValue));
        return baseResponse;
    }

    @Override
    public BaseResponse<String> updateProviderGoods(ProviderGoodsDto providerGoodsDto) {

        BaseResponse baseResponse = providerGoodsService.updateProviderGoods(providerGoodsDto);

        return baseResponse;
    }

    @Override
    public BaseResponse modifyGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId) {

        BaseResponse baseResponse = providerGoodsService.updateGoodsStatus(providerGoodsStatusList, storeId);

        return baseResponse;
    }

    @Override
    public BaseResponse modifyGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId) {

        BaseResponse baseResponse = providerGoodsService.updateGoodsPrice(providerGoodsPriceList, storeId);

        return baseResponse;
    }

    @Override
    public BaseResponse modifyGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId) {

        BaseResponse baseResponse = providerGoodsService.updateGoodsStock(providerGoodsStockList, storeId);

        return baseResponse;
    }

    @Override
    public BaseResponse queryGoods(List<String> skus, String storeId) {

        BaseResponse baseResponse = providerGoodsService.queryGoods(skus, storeId);

        return baseResponse;
    }

    @Override
    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo) {

        BaseResponse baseResponse = providerGoodsService.occupyStock(localStoreOrderVo);

        return baseResponse;
    }

    @Override
    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        return providerGoodsService.cancelOccupyStock(thrOrderNo, storedId);
    }


//    @Override
//    public BaseResponse<String> updateProviderProduct(List<ProviderGoodsDto> providerGoodsDtos) {
//        BaseResponse baseResponse = new BaseResponse();
//        for (ProviderGoodsDto providerGoodsDto : providerGoodsDtos) {
//            BaseResponse simple = providerGoodsService.updateProviderGoods(providerGoodsDto);
//            if (!MessageDictionary.RETURN_SUCCESS_CODE.equals(simple.getResultCode()) || !simple.isSuccess()) {
//                throw new RuntimeException("批量更新商品错误，商品" + providerGoodsDto.getSku() + ",错误信息：" + simple.getResultMessage());
//            }
//        }
//        baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
//        baseResponse.setSuccess(true);
//        baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
//        baseResponse.setResult("");
//        return baseResponse;
//    }


    @Override
    public BaseResponse<List<ProviderGoodsDto>> updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo) {
        BaseResponse baseResponse = providerGoodsService.updateProviderProduct(updateProviderGoodsVo);
        return baseResponse;
    }

    @Override
    public BaseResponse<String> saveProviderProduct(ProductModelDto productModel, List<ProviderGoodsDto> providerGoodsDtos) {
        logger.info("第三方供应商对接接口，保存商品接口输入参数：{}", JSON.toJSONString(providerGoodsDtos, SerializerFeature.WriteMapNullValue));
        BaseResponse baseResponse = providerGoodsService.saveProviderProduct(productModel, providerGoodsDtos);
        return baseResponse;
    }

    @Override
    public ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId) {
        logger.info("商品管理，查询单个商品接口输入参数：{},{}", sku, storeId);
        ProviderGoodsDto goodsDto = providerGoodsService.queryProviderGoodsDto(sku, storeId);
        logger.info("商品管理，查询单个商品接口输出参数：{}", JSON.toJSONString(goodsDto, SerializerFeature.WriteMapNullValue));
        return goodsDto;
    }

    /**
     * 设置优选或上下架
     * type 1 优选 2 不优选 3 上架 4 下架
     * <p>
     * taofeng
     */
    @Override
    @Transactional
    public BaseResponse<List<String>> preferredOrIsUp(GoodsUpperAndLowerVo goodsUpperAndLowerVo) {

        long timerGetSimilarProduct = System.currentTimeMillis();

        //页面勾选全选时
        if (!Lang.isEmpty(goodsUpperAndLowerVo.getIsAllGoods())) {
            goodsUpperAndLowerVo.getGoodsUpperLowerDtos().clear();
            BaseResponse<List<GoodsUpperAndLowerDto>> baseResponse = providerGoodsService.findGoodsUpperAndLowersByQuery(goodsUpperAndLowerVo.getGoodsUpperAndLowerQueryDto());
            if (baseResponse.isSuccess()) {
                int size = baseResponse.getResult().size();
                if (baseResponse.getResult().size() > LIMIT) {
                    size = LIMIT;
                }
                for (int i = 0; i < size; i++) {
                    if (!Lang.isEmpty(baseResponse.getResult().get(i)) && !Lang.isEmpty(baseResponse.getResult().get(i).getSku())) {
                        GoodsUpperLowerDto goodsUpperLowerDto = new GoodsUpperLowerDto();
                        goodsUpperLowerDto.setSku(baseResponse.getResult().get(i).getSku());
                        goodsUpperLowerDto.setStoreId(baseResponse.getResult().get(i).getStoreId());
                        goodsUpperAndLowerVo.getGoodsUpperLowerDtos().add(goodsUpperLowerDto);
                    }
                }
            }
        }
        //多线程批量去执行
        BaseResponse<List<String>> response = providerGoodsService.preferredOrIsUpByThread(goodsUpperAndLowerVo);

        log.info(" type {} 耗时 {} ms , 结果 {} ", goodsUpperAndLowerVo.getOpertionCode(), System.currentTimeMillis() - timerGetSimilarProduct, response.toString());
        return response;
    }

    @Override
    public List<ProviderGoodsDto> queryProviderGoodsDtoList(String modelSku, String storeId) {
        logger.info("商品管理,查询多个商品接口输入参数：{},{}", modelSku, storeId);
        List<ProviderGoodsDto> goodsDtos = providerGoodsService.queryProviderGoodsDtoList(modelSku, storeId);
        logger.info("商品管理，查询多个商品接口输入参数：{}", JSON.toJSONString(goodsDtos, SerializerFeature.WriteMapNullValue));
        return goodsDtos;
    }


    @Override
    public BaseResponse deleteProviderGoodsBatch(List<String> skus, String storeId) {

        return providerGoodsService.deleteProviderGoodsBatch(skus, storeId);

    }

    @Override
    public List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, Boolean isDelete) {
        return providerGoodsService.findByModelSkuAndStoreIdAndIsDelete(modelSku, storeId, isDelete);
    }

    @Override
    public void updateBrandInfo(String id, String brandName, String brandId) {
        providerGoodsService.updateBrandInfo(id, brandName, brandId);
    }


}
