package pool.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pool.api.ProviderProductModelApi;
import pool.dto.ProductModelDto;
import pool.dto.ProductModelQueryDto;
import pool.service.service.ProductModelService;
import pool.vo.ProductModelVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

@MotanService
public class ProviderProductModelApiImpl implements ProviderProductModelApi {
    private static final Logger logger = LoggerFactory.getLogger(ProviderProductModelApiImpl.class);
    @Autowired
    private ProductModelService productModelService;

    @Override
    public BaseResponse<ProductModelDto> saveModel(ProductModelDto productModelDto) {

        BaseResponse<ProductModelDto> baseResponse = productModelService.saveModel(productModelDto);

        return baseResponse;
    }

    @Override
    public BaseResponse<PageVo<ProductModelVo>> queryModels(ProductModelQueryDto productModelQueryDto) {

        BaseResponse<PageVo<ProductModelVo>> baseResponse = productModelService.queryModels(productModelQueryDto);

        return baseResponse;
    }

    @Override
    public BaseResponse<ProductModelDto> updateModel(ProductModelDto productModelDto) {

        BaseResponse<ProductModelDto> baseResponse = productModelService.updateModel(productModelDto);

        return baseResponse;
    }

    @Override
    public BaseResponse<String> deleteModel(String modelId, String storeId) {

        BaseResponse<String> baseResponse = productModelService.deleteModel(modelId, storeId);

        return baseResponse;
    }

    @Override
    public List<ProductModelDto> findByBrandIdAndIsDelete(String providerProductBrandId, Boolean isDelete) {
        List<ProductModelDto> productModelDtoList = productModelService.findByBrandIdAndIsDelete(providerProductBrandId, isDelete);
        return productModelDtoList;
    }

    @Override
    public ProductModelDto findByModelSkuAndStoreId(String modelSku, String storeId) {
        ProductModelDto productModelDto = productModelService.findByModelSkuAndStoreId(modelSku, storeId);
        return productModelDto;
    }

}
