package pool.service.apiImpl.providermanager.brandmanager;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import pool.api.ProviderBrandMangerApi;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.service.service.BrandService;
import pool.vo.BrandVo;
import pool.vo.query.brand.brandmapper.BrandMapperQueryVo;
import utils.sql.PageVo;

import java.util.List;

@MotanService
public class ProviderBrandManagerApiImpl implements ProviderBrandMangerApi {
    @Autowired
    private BrandService brandService;

    @Override
    public int findCountByStandardBrandId(String standardBrandId){
        return brandService.findCountByStandardBrandId(standardBrandId);
    }
    @Override
    public PageVo<BrandMapperDto> pageQueryForMapper(BrandMapperQueryVo brandMapperQueryVo, Pageable pageable){
        return brandService.pageQueryForMapper(brandMapperQueryVo,pageable);
    }
    @Override
    public BrandMapperDto findOneById(String id){
        return brandService.findById(id);
    }
    @Override
    public Boolean bindStandardBrand(String id ,String productBrandId){
        return brandService.bindStandardBrand(id,productBrandId);
    }

    @Override
    public Boolean cancelBindStandardBrand(String id){
        return brandService.cancelBindStandardBrand(id);
    }

    @Override
    public List<BrandMapperDto> findStores(){
        return brandService.findStores();
    }

    @Override
    public List<String> findStoresOfProviderByProductCategoryId(String productCategoryId){
        return brandService.findStoresOfProviderByProductCategoryId(productCategoryId);
    }

    @Override
    public void updateProviderBrandMappingInfo(BrandVo brandVo) {
        brandService.updateProviderBrandMappingInfo(brandVo);
    }
}
