package pool.service.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductBrandApi;
import goods.dto.ProductBrandSelectDto;
import goods.dto.product.ProductBrandDto;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pool.api.ProductCategoryApi;
import pool.api.ProviderBrandMangerApi;
import pool.api.ProviderProductBrandApi;
import pool.api.ProviderProductModelApi;
import pool.dto.BrandDto;
import pool.model.ProviderProductFashionPicture;
import pool.model.ProviderProduct;
import pool.model.ProviderProductFashion;
//import pool.model.repository.CategoryRepos;
import pool.model.repository.ProviderProductRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.BrandService;
import pool.service.service.ProviderAddressService;
import pool.service.service.ProviderGoodsService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.string.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.*;
import java.util.stream.Collectors;

@RestController
public class TestController {

    private static final Logger logger = LoggerFactory.getLogger(TestController.class);
//    @Autowired
//    private CategoryRepos categoryRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private ProductCategoryApi categoryApi;
    @Autowired
    private ProviderProductBrandApi brandApi;
    @Autowired
    private ProviderProductModelApi providerProductModelApi;
    @Autowired
    private ProviderGoodsService providerProductService;
    @Autowired
    private ProviderAddressService providerAddressService;
    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;
    @Autowired
    private ProviderBrandMangerApi providerBrandMangerApi;

    @Autowired
    private RedisTemplate redisTemplate;
    @MotanReferer
    ProductBrandApi productBrandApi;

    /**
     * 测试接口
     * @return
     */
    @RequestMapping(value = "get/testMethod")
    public Object testMethod(HttpServletRequest request){
        BaseResponse baseResponse =new BaseResponse();
        //测试一
//        Integer count = categoryRepos.findCount();
//        baseResponse.setSuccess(true);
//        baseResponse.setResultMessage("测试成功");
//        baseResponse.setResultCode("0000");
//        baseResponse.setResult(count);


        //测试二:测试商品分类接口需要用到的方法：
//        Pageable pageable = new PageRequest(0,10);
//        Page<Category> page = categoryRepos.findAll(pageable);
//        List<Category> categoryList = page.getContent(); //查询结果集
//        Integer total = page.getNumberOfElements();  //总数量
//        List<CategoryVo> categoryVoList = mapperFacade.mapAsList(categoryList,CategoryVo.class);
//        baseResponse.setSuccess(true);
//        baseResponse.setResultMessage("测试成功");
//        baseResponse.setResultCode("0000");
//        baseResponse.setResult(categoryVoList);


        //接口1:测试CategoryApiImpl方法：
//        CategoryQueryDto categoryQueryDto = new CategoryQueryDto();
//        categoryQueryDto.setPageNo(1);
//        categoryQueryDto.setPageSize(10);
//        baseResponse = categoryApi.findByCategoryQuery(categoryQueryDto);
//        //对外数据封装
//        Map<String,Object> map = new HashMap<>();
//        if(baseResponse.isSuccess()){  //成功
//            PageVo<CategoryVo> content = (PageVo<CategoryVo>)baseResponse.getResult();
//            map.put("totalRows",content.getTotalCount());
//            map.put("pageNo",content.getPageNum());
//            map.put("pageSize",content.getPageSize());
//            map.put("categorys",content.getResult());
//        }
//        baseResponse.setResult(map);
//        return baseResponse;

        //测试2：创建商品品牌
//        BrandDto brandDto = new BrandDto();
//        brandDto.setName("百乐");
//        brandDto.setSimpleName("百乐");
//        brandDto.setDescription("测试描述2990qqwwe");
//        brandDto.setWebsitesUrl("https://www.baidu.com");
//        brandDto.setCategoryId("123467890");
//        brandDto.setStoreId("3456345000");
//        baseResponse =brandApi.saveBrand(brandDto);
//        return baseResponse;

//        //测试3：查询品牌
//        // 遗留问题：数据库没有存sourceCode字段，返回结果中的这个值从哪里获取？？？
//        BrandQueryDto brandQueryDto = new BrandQueryDto();
//        brandQueryDto.setPageNo(0);
//        brandQueryDto.setPageSize(10);
//        baseResponse = brandApi.queryBrands(brandQueryDto);
//        //对外数据封装
//        Map<String,Object> map = new HashMap<>();
//        if(baseResponse.isSuccess()){  //成功
//            PageVo<BrandVo> content = (PageVo<BrandVo>)baseResponse.getResult();
//            map.put("totalRows",content.getTotalCount());
//            map.put("pageNo",content.getPageNum());
//            map.put("pageSize",content.getPageSize());
//            map.put("productBrands",content.getResult());
//        }
//        baseResponse.setResult(map);
//        return baseResponse;
        //接口4：删除品牌
//        String brandId = "8e474ba7-b30d-4369-8dc0-261f25ae09fb";
//        baseResponse=brandApi.deleteBrand(brandId);
//        return baseResponse;
        //接口5：商品模型创建
//        ProductModelDto productModelDto = new ProductModelDto();
//        productModelDto.setBrandId("539eea84-f4f1-413e-83be-ad0d1114d154");     //BAILE
//        productModelDto.setCategoryId("68a9867b-e9ce-4299-abed-09d870124435");  //鞋类
//        productModelDto.setName("BAILE");
//        productModelDto.setModelSku("BAILE18993");
//        baseResponse = providerProductModelApi.saveModel(productModelDto); //需要改造：隐藏brandId，categoryId
//        Map<String,String> map = new HashMap<String,String>();
//        ProductModelDto pmd = (ProductModelDto)baseResponse.getResult();
        //@TODO 获取 mainSku，后续要处理的内容
//        return baseResponse;
//        //接口6：商品模型列表查询
//        ProductModelQueryDto productModelQueryDto = new ProductModelQueryDto();
//        productModelQueryDto.setPageNo(0);
//        productModelQueryDto.setPageSize(10);
//        baseResponse = providerProductModelApi.queryModels(productModelQueryDto);
//                //对外数据封装
//        Map<String,Object> map = new HashMap<>();
//        if(baseResponse.isSuccess()){  //成功
//            PageVo<BrandVo> content = (PageVo<BrandVo>)baseResponse.getResult();
//            map.put("totalRows",content.getTotalCount());
//            map.put("pageNo",content.getPageNum());
//            map.put("pageSize",content.getPageSize());
//            map.put("productModels",content.getResult());
//        }
//        baseResponse.setResult(map);
//        return baseResponse;
//        //接口7：修改商品模型
//        ProductModelDto productModelDto = new ProductModelDto();
//        productModelDto.setBrandId("5bbb1c5e-406f-4d12-9d2c-0f699d88c605");     //彪马
//        productModelDto.setCategoryId("68a9867b-e9ce-4299-abed-09d870124435");  //鞋类
//        productModelDto.setName("PUMA修改4");
//        productModelDto.setModelSku("1234562");
//        productModelDto.setModelId("19e55180-d3b6-4474-9b79-7ef849dd635a"); //id
//        baseResponse=providerProductModelApi.updateModel(productModelDto);
//        return baseResponse;
        //接口8：删除商品模型,完成


        //接口9：查询商品列表
//        ProductQueryDto productQueryDto = new ProductQueryDto();
//        productQueryDto.setPageNo(0);
//        productQueryDto.setPageSize(10);
//
//        baseResponse = providerProductService.queryProviderGoodsPage(productQueryDto);
//        return baseResponse;


        //接口10：查询单个商品商品,sku="sku_test"
//        String sku = "sku_test2";
//        baseResponse = providerProductService.queryProviderGoodsPage(sku);
//        return baseResponse;


        //接口11：创建商品
        //测试拷贝ProviderProduct<-->ProviderGoodsDto
//        ProviderGoodsDto productDto = new ProviderGoodsDto();
//        productDto.setSku("sku_test2");
//        productDto.setModelSku("modelSku_test2");
//        productDto.setName("测试商品2");
//        productDto.setCostPrice(new BigDecimal(20.00));
//        productDto.setMarketPrice(new BigDecimal(25.00));
//
//        List<PicDto> pics = new ArrayList<>();
//        PicDto pic_1 = new PicDto();
//        pic_1.setIsPrimary(true);
//        pic_1.setOrderSort(1);
//        pic_1.setPath("http://www.baidu2.com");
//        pic_1.setType("0");
//        pics.add(pic_1);
//        PicDto pic_2 = mapperFacade.map(pic_1,PicDto.class);
//        pic_2.setIsPrimary(false);
//        pic_2.setType("1");
//        pic_2.setOrderSort(2);
//        pics.add(pic_2);
//        productDto.setPics(pics);
//
//        ProviderProductFashion providerProductFashion = mapperFacade.map(productDto,ProviderProductFashion.class);
//        baseResponse = providerProductService.saveProviderGoods(productDto);
//        return baseResponse ;
        //接口12：修改商品
            //修改商品的名称，首先根据sku查出要修改的的商品
//        ProviderGoodsDto productDto = new ProviderGoodsDto();
//        productDto.setSku("sku_test2");
//        productDto.setModelSku("modelSku_test2");
//        productDto.setName("测试商品2_修改2");
//        productDto.setCostPrice(new BigDecimal(201.00));
//        productDto.setMarketPrice(new BigDecimal(251.00));
//        productDto.setStoreId("storeId_test_id");
//
//        List<PicDto> pics = new ArrayList<>();
//        PicDto pic_1 = new PicDto();
//        pic_1.setIsPrimary(false);
//        pic_1.setOrderSort(1);
//        pic_1.setPath("http://www.baidu2.com_update_test");
//        pic_1.setType("0");
//        pics.add(pic_1);
//
//        productDto.setPics(pics);
//
//        baseResponse = providerProductService.updateProviderGoods(productDto);
//        return baseResponse;



        //接口12: 商品上下架状态变更

        //接口13：商品价格变更

        //接口14：商品库存变更

        //接口15：获取省份接口

//        String parentId = "100000";
//        List<ProviderAddress>  providerAddressList = providerAddressService.findAddressByParentId(parentId);
//        return new BaseResponse(true,"查询成功",providerAddressList,"0000");
        return baseResponse;
    }

    /**
     * 测试获取一级、二级、三级、四级地址的接口
     * @param
     * @return
     */
//    @GetMapping(value = "/get/address/{type}")
//    public BaseResponse testRequestParams(HttpServletRequest request, @PathVariable String type,String parentId){
//        String levelType = null;
//        try {
//            if (Lang.isEmpty(type)) {
//                return new BaseResponse(false, "请求url不匹配");
//            } else {
//                switch (type) {
//                    case "province":
//                        levelType = "1";
//                        break;
//                    case "city":
//                        levelType = "2";
//                        break;
//                    case "county":
//                        levelType = "3";
//                        break;
//                    case "town":
//                        levelType = "4";
//                        break;
//                }
//                if (Lang.isEmpty(levelType)) {
//                    return new BaseResponse(false, "请求url不匹配");
//                }
//            }
//
//            if (Lang.equals("1", levelType) && Lang.isEmpty(parentId)) {
//                parentId = "100000"; //数据库中省级的父类id
//            } else if (!Lang.equals("1", levelType) && Lang.isEmpty(parentId)) {
//                return new BaseResponse(false, "请求参数parentId不能为空");
//            }
//            //查询
//            List<ProviderAddress> providerAddressList = providerAddressService.findAddressByParentIdAndLevelType(parentId, levelType);
//            //对外数据封装：
//            Map<String,Object> map =new HashMap();
//            Map<String,String> mapResult = new TreeMap<>();
//            for(ProviderAddress e:providerAddressList){
//                mapResult.put(e.getName(),e.getId());
//            }
//
//            if("1".equals(levelType)){
//                map.put("province",mapResult);
//            }else if("2".equals(levelType)){
//                map.put("city",mapResult);
//            }else if("3".equals(levelType)){
//                map.put("county",mapResult);
//            }else if("4".equals(levelType)){
//                map.put("town",mapResult);
//            }
//
//            return new BaseResponse(true, "操作成功", map, "0000");
//        } catch (Exception e) {
//            e.printStackTrace();
//            return new BaseResponse(false,"内部错误");
//        }
//    }
//    @GetMapping(value = "/get/address/province")
//    public BaseResponse getProvinces(){
//        String parentId = "100000";
//        String levelType = "1";
//        return getAddress(parentId,levelType);
//    }
//    @GetMapping(value = "/get/address/city")
//    public BaseResponse getCitys(@RequestParam("province_id") String provinceId){
//        if(Lang.isEmpty(provinceId)){
//            new BaseResponse(false,"请求参数不能为空");
//        }
//        String levelType = "2";
//        String parentId = provinceId;
//        return getAddress(parentId,levelType);
//    }
//    @GetMapping(value = "/get/address/county")
//    public BaseResponse getCountys(@RequestParam("city_id") String cityId){
//        if(Lang.isEmpty(cityId)){
//            new BaseResponse(false,"请求参数不能为空");
//        }
//        String levelType = "3";
//        String parentId = cityId;
//        return getAddress(parentId,levelType);
//    }
//    @GetMapping(value = "/get/address/town")
//    public BaseResponse getTowns(@RequestParam("county_id") String countyId){
//        if(Lang.isEmpty(countyId)){
//            new BaseResponse(false,"请求参数不能为空");
//        }
//        String levelType ="4";
//        String parentId = countyId;
//        return getAddress(parentId,levelType);
//    }
//
//    private BaseResponse getAddress(String parentId,String levelType){
//        //查询
//        List<ProviderAddress> providerAddressList = providerAddressService.findAddressByParentIdAndLevelType(parentId, levelType);
//        //对外数据封装：
//        Map<String,Object> map =new HashMap();
//        Map<String,String> mapResult = new TreeMap<>();
//        for(ProviderAddress e:providerAddressList){
//            mapResult.put(e.getName(),e.getId());
//        }
//        if("1".equals(levelType)){
//            map.put("province",mapResult);
//        }else if("2".equals(levelType)){
//            map.put("city",mapResult);
//        }else if("3".equals(levelType)){
//            map.put("county",mapResult);
//        }else if("4".equals(levelType)){
//            map.put("town",mapResult);
//        }
//
//        return new BaseResponse(true, "操作成功", map, "0000");
//    }
    @Autowired
    private ProviderProductRepos providerProductRepos;

    private ExecutorService executorService = new ThreadPoolExecutor(10, 20, 1, TimeUnit.MINUTES, new LinkedBlockingQueue<>(200000));
    @RequestMapping("update/product")
    public Object updateProduct(){

        int size = 100;
        List<Future> futureList = new ArrayList<>();
        for(int i=0;i<size;i++){
            Future<Object> future = executorService.submit(new Callable<Object>() {
                @Override
                public Object call() {
                    for(int j=0;j<1000;j++){
                        //执行操作：
                        /****************************************************/
                        String storeId = "7506305a-bfb9-79fe-e053-8d75010adfec";    //中科软店铺
                        String categoryId = "e008727d-7359-4a53-b114-57d512e810e1"; //历史
                        String productBrandId = "9db63708-98ce-4ff0-b1ae-e47f0c86e299";   //标准品牌
                        String providerProductBrandId = "efbaa225-53b7-4414-8a11-0"; //供应商品牌
                        String randomStr = Lang.id().substring(0,5);
                        String backStr = StringUtils.Pading("11",4,1,'0');
                        String modelSku = randomStr+"modelSku"+ backStr;
                        String modelName = randomStr +"modelName"+backStr;

                        List<ProviderProductFashionPicture> pics = new ArrayList<>();
                        for(int i=0;i<2;i++){
                            ProviderProductFashionPicture providerProductFashionPicture = new ProviderProductFashionPicture();
                            providerProductFashionPicture.setIsPrimary(false);
                            providerProductFashionPicture.setPath("http://www.baidu.com");
                            pics.add(providerProductFashionPicture);
                        }

                        //创建模型：
                        ProviderProduct providerProduct = new ProviderProduct();
                        providerProduct.setBrandId(providerProductBrandId);
                        providerProduct.setProductBrandId(productBrandId);
                        providerProduct.setModelSku(modelSku);
                        providerProduct.setCategoryId(categoryId);
                        providerProduct.setStoreId(storeId);
                        providerProduct.setName(modelName);
                        providerProduct = providerProductRepos.save(providerProduct); //获取id


                        String sku  = randomStr+"sku"+ backStr;
                        String name = randomStr+"name"+ backStr;

                        //创建模型下的商品：
                        ProviderProductFashion providerProductFashion = new ProviderProductFashion();
                        providerProductFashion.setSku(sku);
                        providerProductFashion.setModelSku(modelSku);
                        providerProductFashion.setWeight("0.00");
                        providerProductFashion.setName(name);
                        providerProductFashion.setSaleUnit("个");
                        providerProductFashion.setIntroduction("介绍详情");
                        providerProductFashion.setGoodsDetail("商品详情");
                        providerProductFashion.setParam("规格参数");
                        providerProductFashion.setCostPrice(new BigDecimal(0.01));
                        providerProductFashion.setMarketPrice(new BigDecimal(0.01));
                        providerProductFashion.setSalePrice(new BigDecimal(0.001));
                        providerProductFashion.setStockCount(100);
                        providerProductFashion.setAfterSaleDetails("售后详情");
                        providerProductFashion.setProviderProduct(providerProduct);
                        providerProductFashion.setStoreId(storeId);
                        providerProductFashion.setPushUpDate(new Date());
                        providerProductFashion.setCategoryId(categoryId);
                        providerProductFashion.setIsHotSale(false);
                        providerProductFashion.setIsSpecial(false);
                        providerProductFashion.setIsRecommend(false);
                        providerProductFashion.setIsNewProduct(false);
                        providerProductFashion.setProviderSaleStatus(1);
                        providerProductFashion.setJudgeFactoryFlag(true);
                        providerProductFashion.setPostSalePolicy(1);
                        providerProductFashion.setInvoiceType(1);
                        providerProductFashion.setPics(pics);
                        //新增商品：
                        providerProductFashionRepos.save(providerProductFashion);
                        /****************************************************/
                    }
                    return null;
                }
            });
            futureList.add(future);
            for(int n=0;n<futureList.size();n++){
                try {
                    futureList.get(n).get();
                    logger.info("添加商品第{}页成功",n+1);
                } catch (Exception e) {
                    logger.info("添加商品第{}页失败",n+1);
                    e.printStackTrace();
                }
            }
        }

//        /****************************************************/
//        try {
//            String storeId = "7506305a-bfb9-79fe-e053-8d75010adfec";    //中科软店铺
//            String categoryId = "e008727d-7359-4a53-b114-57d512e810e1"; //历史
//            String productBrandId = "9db63708-98ce-4ff0-b1ae-e47f0c86e299";   //标准品牌
//            String providerProductBrandId = "efbaa225-53b7-4414-8a11-0"; //供应商品牌
//            String randomStr = Lang.id().substring(0,5);
//            String backStr = StringUtils.Pading("11",4,1,'0');
//            String modelSku = randomStr+"modelSku"+ backStr;
//            String modelName = randomStr +"modelName"+backStr;
//
//            List<ProviderProductFashionPicture> pics = new ArrayList<>();
//            for(int i=0;i<2;i++){
//                ProviderProductFashionPicture productPicture = new ProviderProductFashionPicture();
//                productPicture.setIsPrimary(false);
//                productPicture.setPath("http://www.baidu.com");
//                pics.add(productPicture);
//            }
//
//            //创建模型：
//            ProviderProduct providerProduct= new ProviderProduct();
//            providerProduct.setBrandId(providerProductBrandId);
//            providerProduct.setProductBrandId(productBrandId);
//            providerProduct.setModelSku(modelSku);
//            providerProduct.setCategoryId(categoryId);
//            providerProduct.setStoreId(storeId);
//            providerProduct.setName(modelName);
//            providerProduct = providerProductRepos.save(providerProduct); //获取id
//
//
//            String sku  = randomStr+"sku"+ backStr;
//            String name = randomStr+"name"+ backStr;
//
//            //创建模型下的商品：
//            ProviderProductFashion providerProductFashion = new ProviderProductFashion();
//            providerProductFashion.setSku(sku);
//            providerProductFashion.setModelSku(modelSku);
//            providerProductFashion.setWeight("0.00");
//            providerProductFashion.setName(name);
//            providerProductFashion.setSaleUnit("个");
//            providerProductFashion.setIntroduction("介绍详情");
//            providerProductFashion.setGoodsDetail("商品详情");
//            providerProductFashion.setParam("规格参数");
//            providerProductFashion.setCostPrice(new BigDecimal(0.01));
//            providerProductFashion.setMarketPrice(new BigDecimal(0.01));
//            providerProductFashion.setSalePrice(new BigDecimal(0.001));
//            providerProductFashion.setStockCount(100);
//            providerProductFashion.setAfterSaleDetails("售后详情");
//            providerProductFashion.setProviderProduct(providerProduct);
//            providerProductFashion.setStoreId(storeId);
//            providerProductFashion.setPushUpDate(new Date());
//            providerProductFashion.setCategoryId(categoryId);
//            providerProductFashion.setIsHotSale(false);
//            providerProductFashion.setIsSpecial(false);
//            providerProductFashion.setIsRecommend(false);
//            providerProductFashion.setIsNewProduct(false);
//            providerProductFashion.setProviderSaleStatus(1);
//            providerProductFashion.setJudgeFactoryFlag(true);
//            providerProductFashion.setPostSalePolicy(1);
//            providerProductFashion.setInvoiceType(1);
//            providerProductFashion.setPics(pics);
//
//            //新增商品：
//            providerProductFashion =  providerProductFashionRepos.save(providerProductFashion);
//            logger.error("模型id：{}，商品id：{}",providerProduct.getModelId(),providerProductFashion.getId());
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//
//        /****************************************************/

        //测试id=c360c099-d152-4143-983f-e3298d4f2b4a
//        String id = "c360c099-d152-4143-983f-e3298d4f2b4a";
//        ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOne(id);
//        providerProductFashion.setProviderSaleStatus(1);
//        providerProductFashion.setPushUpDate(new Date());
//        providerProductFashionRepos.save(providerProductFashion);    //没有更改集合属性的值（符合预期）
//        System.out.println("上下架状态："+ providerProductFashion.getProviderSaleStatus());
//        return new BaseResponse<>(true,"操作成功");


//        BrandMapperQueryVo brandMapperQueryVo = new BrandMapperQueryVo();
//        brandMapperQueryVo.setStoreId("8ce42ec1-8c83-4f22-80c6-e31cdc0dab14");
//        brandMapperQueryVo.setMatchFlag("0");
//        brandMapperQueryVo.setMatchSource("0");  //系统匹配来源
//        brandMapperQueryVo.setProductBrandName("联想"); //标准品牌名称
//        brandMapperQueryVo.setName("联想");//供应商品牌
//        brandMapperQueryVo.setLinkOne("1"); //条件1
//        brandMapperQueryVo.setNameOne("苹果");
//        brandMapperQueryVo.setLinkTow("2"); //条件2
//        brandMapperQueryVo.setNameTwo("小米");
//        brandMapperQueryVo.setLinkThree("2");
//        brandMapperQueryVo.setNameThree("nike");

//        Pageable pageable = new PageRequest(1,5);
//        providerBrandMangerApi.pageQueryForMapper(brandMapperQueryVo,pageable);
        return null;
    }
    private static String PROVIDERBRAND_LIST_REDIS_KEY = "admin-web:providerbrand:list";
    @Autowired
    private BrandService brandService;
    @RequestMapping(value = "bacth_create_provider_product_brand")
    public void bacth_create_provider_product_brand(){
        String store_id = "203c652b-f672-4bd8-853e-9c07834c501d" ; // 店铺id
        //获取标准品牌信息
        List<ProductBrandSelectDto> list;
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(PROVIDERBRAND_LIST_REDIS_KEY);
        if (boundValueOperations.get() != null) {
            list = (List<ProductBrandSelectDto>) boundValueOperations.get();
        } else {
            list = productBrandApi.findAllStandardBrand();
            boundValueOperations.set(list);
        }
        List<String> ids = list.stream().map(productBrandSelectDto -> productBrandSelectDto.getId()).collect(Collectors.toList());
        List<List<String>> idsList = Lang.groupListByQuantity(ids,500);
        for(int i=0;i<idsList.size();i++) {
            List<ProductBrandDto> productBrandDtoList = productBrandApi.findByIdIn(idsList.get(i));
            productBrandDtoList.forEach(productBrandDto -> {   //添加供应商品牌
                BrandDto brandDto = new BrandDto();
                brandDto.setName(productBrandDto.getName());
                brandDto.setSimpleName(productBrandDto.getName());
                brandDto.setDescription(productBrandDto.getDescription());
                brandDto.setWebsitesUrl(productBrandDto.getWebsitesUrl());
                brandDto.setStoreId(store_id);
                brandService.saveBrand(brandDto);
            });
        }
    }
}
