package pool.service.service;

import org.springframework.data.domain.Pageable;
import pool.dto.BrandDto;
import pool.dto.BrandQueryDto;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.vo.BrandVo;
import pool.vo.query.brand.brandmapper.BrandMapperQueryVo;
import pool.vo.ProviderProductBrandVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;
import java.util.Map;

public interface BrandService {
    /**
     * 创建商品品牌
     */
    BaseResponse<Map<String,String>> saveBrand(BrandDto brandDto);

    /**
     * 查询品牌,分页
     */
    BaseResponse<PageVo<BrandVo>> queryBrands(BrandQueryDto brandQueryDto);

    /**
     * 查询供应商品牌
     * by id
     */
    BrandMapperDto queryBrand(String id);

    /**
     * 删除品牌 逻辑删除
     */

    BaseResponse<String> deleteBrand(String brandId);

    /**
     * 根据标准化品牌id，获取映射该id下的供应商品牌数量
     */
    int findCountByStandardBrandId(String standardBrandId);

    /**
     * 品牌映射查询
     */
    PageVo<BrandMapperDto> pageQueryForMapper(BrandMapperQueryVo brandMapperQueryVo, Pageable pageable);

    /**
     * 根据供应商品牌id获取品牌的信息
     */
    BrandMapperDto findById(String id);

    /**
     * 供应商品牌绑定标准品牌id
     */
    Boolean bindStandardBrand(String id ,String productBrandId);

    /**
     * 取消绑定
     * @param id
     * @return
     */
    Boolean cancelBindStandardBrand(String id);

    /**
     * 查询店铺
     * id、name
     */

    List<BrandMapperDto> findStores();

    ProviderProductBrandVo findBrandByNameAndStoreId(String brandName, String storeId);

    /**
     * 查询供应商商品在指定分类下的所有店铺ids
     */
    List<String> findStoresOfProviderByProductCategoryId(String productCategoryId);

    void updateProviderBrandMappingInfo(BrandVo brandVo);
}
