package pool.service.service;

import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryconfigApi;
import goods.dto.product.ProductCategoryConfigDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pool.model.ProviderProduct;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductBrandRepos;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.model.repository.ProviderProductFashionRepos;
import utils.Lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Jian on 2018-8-29.
 */
@Slf4j
@Service
public class GoodsAutosyncFilterService {

    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;
    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;
    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    OrganizationApiStub organizationApiStub;
    @MotanReferer
    ProductCategoryconfigApi productCategoryconfigApi;
    @Autowired
    StoreService storeService;

    static String UNINOGIFT ="uninogift";

    public Map autoUpCategoryBrandMappingFilter(List<String> skus, String storeId) {
        Map rsData = new HashMap();
        List<String> upSuccessMsgList = new ArrayList<>();
        List<String> upFailList = new ArrayList<>();
        for (int i = 0; i < skus.size(); i++) {
            List<ProviderProductFashion> goodsList = providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(skus.get(i), storeId, false);
            if (!Lang.isEmpty(goodsList)) {
                ProviderProductFashion providerProductFashion = goodsList.get(0);
                ProviderProduct model = providerProductFashion.getProviderProduct();

                if (Lang.isEmpty(model) || Lang.isEmpty(model.getCategoryId()) || Lang.isEmpty(model.getProductBrandId())) {
                    upFailList.add(skus.get(i));
                    log.info("sku:{}上架，分类品牌未映射,storeId:{}",skus.get(i),storeId);
                    continue;
                }
                upSuccessMsgList.add(skus.get(i));
            } else {
                upFailList.add(skus.get(i));
                log.info("sku:{}上架，商品不存在,storeId:{}",skus.get(i),storeId);
                continue;
            }
        }

        rsData.put("upSuccessMsgList", upSuccessMsgList);
        rsData.put("upFailList", upFailList);
        return rsData;
    }

    public Map autoUpCategoryOrgUpFilter(String sku, String storeId, List<OrganizationDto> orgs) {
        Map rsData = new HashMap();
        List<ProviderProductFashion> goodsList = providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(sku, storeId, false);
        ProviderProduct model = goodsList.get(0).getProviderProduct();
        List<String> organizationList = new ArrayList<>();
        for (OrganizationDto org:orgs) {
            if(UNINOGIFT.equals(org.getOrgCode())) {
                continue;
            }
            ProductCategoryConfigDto pcc = productCategoryconfigApi.findByProductCategoryIdAndOrganizationId(model.getCategoryId(), org.getId());
            if (Lang.isEmpty(pcc) || Lang.isEmpty(pcc.getIsUp()) || !pcc.getIsUp()) {
                log.info("sku:{}上架，三级分类：{}未在：{}上架,storeId:{}",sku,model.getCategoryId(),org.getOrgCode(),storeId);
                continue;
            } else {
                organizationList.add(org.getOrgCode());
            }
        }
        rsData.put("organizationList", organizationList);
        return rsData;
    }

}
