package pool.service.service;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author torvalds on 2018/8/29 13:38.
 * @version 1.0
 */
@Component
public class OrganizationApiStub {
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    RedisTemplate redisTemplate;

    private String ORGNIZATION_CODE_KEY = "provider-service:organization:";

    /**
     * 查询合作伙伴
     * @param organizationCode
     * @return
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public OrganizationDto findOrganizationByOrgCode(String organizationCode) {
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(ORGNIZATION_CODE_KEY + organizationCode);
        if (boundValueOperations.get() != null) {
            return (OrganizationDto) boundValueOperations.get();
        }
        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
        boundValueOperations.set(organization, 1, TimeUnit.DAYS);
        return organization;
    }


    /**
     * 查询合作伙伴
     * @return
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public List<OrganizationDto> findOrganizationAll() {
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(ORGNIZATION_CODE_KEY + "all");
        if (boundValueOperations.get() != null) {
            return (List<OrganizationDto>) boundValueOperations.get();
        }
        List<OrganizationDto> organizations = organizationApi.findOrganizationAll();
        boundValueOperations.set(organizations, 1, TimeUnit.DAYS);
        return organizations;
    }
}
