package pool.service.service;

import pool.dto.ProductModelDto;
import pool.dto.ProductModelQueryDto;
import pool.vo.BrandVo;
import pool.vo.ProductModelVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

public interface ProductModelService {
    /**
     * 5. 商品模型查询
     *
     * @param productModelQueryDto
     * @return
     */
    BaseResponse<PageVo<ProductModelVo>> queryModels(ProductModelQueryDto productModelQueryDto);

    /**
     * 6.商品模型创建
     *
     * @param productModelDto
     * @return
     */
    BaseResponse<ProductModelDto> saveModel(ProductModelDto productModelDto);

    /**
     * 7.商品模型修改
     *
     * @param productModelDto
     * @return
     */
    BaseResponse<ProductModelDto> updateModel(ProductModelDto productModelDto);

    /**
     * 8.商品模型删除
     *
     * @param modelId
     * @return
     */
    BaseResponse<String> deleteModel(String modelId, String storeId);

    List<ProductModelDto> findByBrandIdAndIsDelete(String providerProductBrandId, Boolean isDelete);

    ProductModelDto findByModelSkuAndStoreId(String modelSku, String storeId);

    boolean isSynCateAndBrand(String sku, String storeId, String orgCode);

    void updateProviderProductMappingInfo(String providerBrandId, boolean isDelete, BrandVo brandVo);
}
