package pool.service.service;

import localstore.dto.LocalStoreOrderVo;
import pool.dto.*;
import pool.vo.GoodsUpperAndLowerVo;
import pool.vo.ProviderGoodsVo;
import pool.vo.UpdateProviderGoodsVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

public interface ProviderGoodsService {
    /**
     * 创建商品
     *
     * @param providerGoodsDto
     * @return
     */
    BaseResponse saveProviderGoods(ProviderGoodsDto providerGoodsDto);

    /**
     * 查询商品
     *
     * @param sku
     * @return
     */
    BaseResponse queryProviderGoods(String sku, String storeId);

    /**
     * 修改商品
     *
     * @param providerGoodsDto
     * @return
     */
    BaseResponse updateProviderGoods(ProviderGoodsDto providerGoodsDto);

    /**
     * 查询商品列表，分页
     *
     * @param productQueryDto
     * @return
     */
    BaseResponse<PageVo<ProviderGoodsVo>> queryProviderGoodsPage(ProductQueryDto productQueryDto);

    /**
     * 更新商品的上下架状态
     */
    BaseResponse updateGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId);

    /**
     * 更新商品的价格
     *
     * @param providerGoodsPriceList
     * @param storeId
     * @return
     */
    BaseResponse updateGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId);

    /**
     * 更新商品的库存
     *
     * @param providerGoodsStockList
     * @param storeId
     * @return
     */
    BaseResponse updateGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId);

    /**
     * 查询多个商品（上下架状态，价格，库存）
     *
     * @param skus,storeIds
     * @return
     */
    BaseResponse queryGoods(List<String> skus, String storeId);

    /**
     * 预占库存接口
     *
     * @param localStoreOrderVo
     * @return
     */
    BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo);

    /**
     * 取消预占库存
     * @param thrOrderNo
     * @param storedId
     * @return
     */
    BaseResponse cancelOccupyStock(String thrOrderNo, String storedId);

    BaseResponse<List<GoodsUpperAndLowerDto>> findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto);

    BaseResponse deleteProviderGoodsBatch(List<String> skus, String storeId);

    /**
     * 查询单个商品
     * <p>
     * dy
     */
    public ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId);

    public List<ProviderGoodsDto> queryProviderGoodsDtoList(String sku, String storeId);

    List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, Boolean isDelete);

    void updateBrandInfo(String id, String brandName, String brandId);

    /**
     * taofeng
     */
    BaseResponse<List<String>> preferredOrIsUpByThread(GoodsUpperAndLowerVo goodsUpperAndLowerVo);


    public BaseResponse<String> saveProviderProduct(ProductModelDto productModel, List<ProviderGoodsDto> providerGoodsDtos);

    BaseResponse<List<ProviderGoodsDto>>
    updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo);
}
