package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductBrandApi;
import goods.dto.product.ProductBrandDto;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.commonUtil.MessageDictionary;
import pool.dto.*;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.model.ProviderProductBrand;
import pool.model.repository.ProviderProductBrandRepos;
import pool.service.service.BrandService;
import pool.service.service.ProductModelService;
import pool.service.service.ProviderGoodsService;
import pool.vo.BrandVo;
import pool.vo.ProductBrandPageVo;
import pool.vo.ProviderProductBrandVo;
import pool.vo.query.brand.brandmapper.BrandMapperQueryVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.PageVo;
import utils.sql.QueryByPage;
import utils.string.ChineseInital;
import utils.string.StringUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class BrandServiceImpl implements BrandService {

    private static final Logger logger = LoggerFactory.getLogger(BrandServiceImpl.class);

    @Autowired
    private ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private QueryByPage queryByPage;
    @Autowired
    private ProductModelService productModelService;
    @Autowired
    private ProviderGoodsService providerGoodsService;
    @MotanReferer
    private ProductBrandApi productBrandApi;

    /**
     * 创建品牌
     *
     * @param brandDto
     * @return
     */
    @Override
//    @Transactional
    public BaseResponse<Map<String, String>> saveBrand(BrandDto brandDto) {
        BaseResponse<Map<String, String>> baseResponse = null;
        try {
            if (Lang.isEmpty(brandDto)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (Lang.isEmpty(brandDto.getName())) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_NAME_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            ProviderProductBrand providerProductBrand = mapperFacade.map(brandDto, ProviderProductBrand.class);//对象转换
            // @TODO 新增前判断根据**是否存在:根据名称和店铺id
            List<ProviderProductBrand> validateProviderProductBrand = this.providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(brandDto.getName(), brandDto.getStoreId(),false);
            if (!Lang.isEmpty(validateProviderProductBrand)) {
                return new BaseResponse(false, MessageDictionary.RETURN_ALREADY_EXIST_BRAND_MESSAGE, "", MessageDictionary.RETURN_ALREADY_EXIST_OBJECT_CODE);
            }
            //系统自动添加品牌映射关系
            //分割字符串：
            String ch_name = null ;
            String en_name = null;
            String[] nameArray = splitName(brandDto.getName());
            if(nameArray.length == 2){
                ch_name = nameArray[0];
                en_name = nameArray[1];
            }else if(nameArray.length == 1){
                if(StringUtils.isChinese(nameArray[0])){
                    ch_name = nameArray[0] ;
                }else{
                    en_name = nameArray[0] ;
                }
            }
            List<BrandVo> list = new ArrayList<>();
            if(!Lang.isEmpty(ch_name) || !Lang.isEmpty(en_name)){
                list = findProductBrand(ch_name,en_name);
            }

            if(list.size() > 0){
                providerProductBrand.setProductBrandId(list.get(0).getId());
                providerProductBrand.setProductBrandName(list.get(0).getName());
                providerProductBrand.setMatchSource("1");  //匹配来源为 系统来源
                providerProductBrand.setMatchFlag("1");     //匹配状态为 已匹配
            }else{
                providerProductBrand.setMatchFlag("0");  //未匹配
                providerProductBrand.setMatchSource("0"); //没有来源
            }

            //首字母
            String firstLetter = ChineseInital.getFirstLetter(brandDto.getName());
            providerProductBrand.setFirstLetter(firstLetter.toUpperCase());

            providerProductBrand = this.providerProductBrandRepos.saveAndFlush(providerProductBrand);//新增或修改

            baseResponse = new BaseResponse();
            Map<String, String> map = new HashMap<>();
            map.put("brandId", providerProductBrand.getId());
            baseResponse.setResult(map);
            baseResponse.setSuccess(true);
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }
        return baseResponse;

    }

    /**
     * 查询品牌,分页,返回结果缺少：sourceCode 来源未知
     *
     * @param brandQueryDto
     * @return
     */
    @Override
    public BaseResponse<PageVo<BrandVo>> queryBrands(BrandQueryDto brandQueryDto) {
        BaseResponse baseResponse = new BaseResponse<>();
        try {
            if (!Lang.isEmpty(brandQueryDto) && Lang.isEmpty(brandQueryDto.getPageNo())) {
                brandQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            if (!Lang.isEmpty(brandQueryDto) && Lang.isEmpty(brandQueryDto.getPageSize())) {
                brandQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            if (Lang.isEmpty(brandQueryDto)) {
                brandQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
                brandQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            //查询是当前num需要减1作为数据库的查询条件
            int realPageNo = brandQueryDto.getPageNo() - 1 > 0 ? brandQueryDto.getPageNo() - 1 : 0;
            Pageable pageable = new PageRequest(realPageNo, brandQueryDto.getPageSize());
            pool.model.ProviderProductBrand providerProductBrand = new pool.model.ProviderProductBrand();
            providerProductBrand.setCategoryId(brandQueryDto.getCategoryId());
            providerProductBrand.setId(brandQueryDto.getBrandId());
            Specification<pool.model.ProviderProductBrand> specification = new Specification<pool.model.ProviderProductBrand>() {
                @Override
                public Predicate toPredicate(Root<pool.model.ProviderProductBrand> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                    List<Predicate> predicates = new ArrayList<>();
                    if (!Lang.isEmpty(providerProductBrand.getCategoryId())) {
                        predicates.add(criteriaBuilder.equal(root.get("categoryId"), providerProductBrand.getCategoryId()));
                    }
                    if (!Lang.isEmpty(providerProductBrand.getId())) {
                        predicates.add(criteriaBuilder.equal(root.get("id"), providerProductBrand.getId()));
                    }
                    if (!Lang.isEmpty(providerProductBrand.getStoreId())) {
                        predicates.add(criteriaBuilder.equal(root.get("storeId"), providerProductBrand.getStoreId()));
                    }
                    predicates.add(criteriaBuilder.equal(root.get("isDelete"), false));
                    return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
                }
            };
            Page<pool.model.ProviderProductBrand> page = this.providerProductBrandRepos.findAll(specification, pageable);
            List<pool.model.ProviderProductBrand> providerProductBrandList = page.getContent();

//            List<BrandVo> brandVoList = mapperFacade.mapAsList(brandList,BrandVo.class);

            List<BrandVo> brandVos = new ArrayList<>();
            for (pool.model.ProviderProductBrand item : providerProductBrandList) {
                BrandVo brandVo = new BrandVo();
                brandVo.setId(item.getId());
                brandVo.setName(item.getName());
                brandVo.setSimpleName(item.getSimpleName());
                brandVo.setDescription(item.getDescription());
                brandVo.setIsCarefullyChosen(item.getIsCarefullyChosen());
                brandVo.setIsDisable(item.getIsDisable());
                brandVo.setWebsitesUrl(item.getWebsitesUrl());
                brandVo.setSourceCode(item.getStoreId());      // 品牌来源
                brandVos.add(brandVo);
            }
            ProductBrandPageVo productBrandPageVo = new ProductBrandPageVo(brandVos, page.getNumber() + 1, page.getSize(), page.getTotalElements());
            baseResponse.setResult(productBrandPageVo);
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            baseResponse.setSuccess(true);
        } catch (Exception e) {
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @Override
    public BrandMapperDto queryBrand(String id) {
        BrandMapperDto brandMapperDto = new BrandMapperDto();
        pool.model.ProviderProductBrand providerProductBrand = this.providerProductBrandRepos.findOne(id);
        if(!Lang.isEmpty(providerProductBrand)){
            brandMapperDto.setId(providerProductBrand.getId());
            brandMapperDto.setName(providerProductBrand.getName());
            brandMapperDto.setProductBrandId(providerProductBrand.getProductBrandId());
        }else{
            return null;
        }
        return brandMapperDto;
    }

    @Override
    @Transactional
    public BaseResponse<String> deleteBrand(String brandId) {
        BaseResponse<String> baseResponse;
        try {
            if (Lang.isEmpty(brandId)) {
                new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            pool.model.ProviderProductBrand providerProductBrand = this.providerProductBrandRepos.findOne(brandId);
            if (Lang.isEmpty(providerProductBrand)) {
                baseResponse = new BaseResponse<>(false, MessageDictionary.RETURN_NO_EXIST_BRAND_MESSAGE, "", MessageDictionary.RETURN_NO_EXIST_OBJECT_CODE);
                return baseResponse;
            }
            if (!Lang.isEmpty(providerProductBrand) && providerProductBrand.getIsDelete()) {
                baseResponse = new BaseResponse<>(false, MessageDictionary.RETURN_ALREADY_LOGIC_DELETE_BRAND_MESSAGE, "", MessageDictionary.RETURN_ALREADY_LOGIC_DELETE_CODE);
                return baseResponse;
            }
            providerProductBrand.setIsDelete(true);        //删除
            this.providerProductBrandRepos.save(providerProductBrand);
            baseResponse = new BaseResponse<>(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, "", MessageDictionary.RETURN_SUCCESS_CODE);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }
        return baseResponse;
    }

    /**
     * 获取指定标准化品牌下的映射供应商品牌个数
     */
    @Override
    public int findCountByStandardBrandId(String standardBrandId) {
        return providerProductBrandRepos.findByProductBrandId(standardBrandId);
    }

    /**
     * 品牌映射查询,使用jdbcTemplate实现
     * 分页参数：第几页 每页大小数
     * 查询条件参数
     */
    @Override
    public PageVo<BrandMapperDto> pageQueryForMapper(BrandMapperQueryVo brandMapperQueryVo, Pageable pageable) {
        PageVo<BrandMapperDto> pageVo = new PageVo<>() ;
        try {
        //jdbcTemplate调用：
        List argsList = new ArrayList();   //加筛选条件
        StringBuffer sb = new StringBuffer("");
        String selectStr = "select a.id as id,a.store_id as storeId ,a.name as name,a.match_source as matchSource,a.match_flag as matchFlag,a.product_brand_id as productBrandId,pb.name as productBrandName,c.store_name as storeName from provider_product_brand a " +
                " left join product_brand pb on pb.id = a.product_brand_id " +
                " left join store b on a.store_id = b.id " +
                " left join store_ext c on c.store_id = b.id ";
        String whereStr = " where 1=1 ";
        sb.append(selectStr).append(whereStr);
        //where 语句
        if (!Lang.isEmpty(brandMapperQueryVo)) {
            if (!Lang.isEmpty(brandMapperQueryVo.getStoreId())) {
                sb.append(" and a.store_id like ?");
                argsList.add("%" + brandMapperQueryVo.getStoreId() + "%");
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getMatchFlag())) {
                sb.append(" and a.match_flag = ?");
                argsList.add(brandMapperQueryVo.getMatchFlag());
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getMatchSource())) {
                sb.append(" and a.match_source = ?");
                argsList.add(brandMapperQueryVo.getMatchSource());
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getProductBrandName())) {
                sb.append(" and pb.name like ?");
                argsList.add("%" + brandMapperQueryVo.getProductBrandName() + "%");
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getName())) {
                sb.append(" and a.name like ?");
                argsList.add("%" + brandMapperQueryVo.getName() + "%");
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getNameOne())) {
                if ("1".equals(brandMapperQueryVo.getLinkOne())) {
                    sb.append(" and a.name like ?");
                    argsList.add("%" + brandMapperQueryVo.getNameOne() + "%");
                }
                if ("2".equals(brandMapperQueryVo.getLinkOne())) {
                    sb.append(" and a.name = ?");
                    argsList.add(brandMapperQueryVo.getNameOne());
                }
            }
            if (!Lang.isEmpty(brandMapperQueryVo.getNameTwo())) {     //组合供应商品牌查询条件
                if ("1".equals(brandMapperQueryVo.getJoinOne())) {  //或者
                    if ("1".equals(brandMapperQueryVo.getLinkTwo())) { //包含
                        sb.append(" or a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameTwo() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkTwo())) { // =
                        sb.append(" or a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameTwo());
                    }
                } else {    //并且
                    if ("1".equals(brandMapperQueryVo.getLinkTwo())) {
                        sb.append(" and a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameTwo() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkTwo())) {
                        sb.append(" and a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameTwo());
                    }
                }
            }
            if(!Lang.isEmpty(brandMapperQueryVo.getNameThree())){
                if ("1".equals(brandMapperQueryVo.getJoinTwo())) {  //或者
                    if ("1".equals(brandMapperQueryVo.getLinkThree())) { //包含
                        sb.append(" or a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameThree() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkThree())) { // =
                        sb.append(" or a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameThree());
                    }
                } else {    //并且
                    if ("1".equals(brandMapperQueryVo.getLinkThree())) {
                        sb.append(" and a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameThree() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkThree())) {
                        sb.append(" and a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameThree());
                    }
                }
            }

            // order by 语句
        }
        Object[] argsArray = argsList.toArray();
             pageVo = queryByPage.query(sb.toString(), BrandMapperDto.class, pageable.getPageNumber(), pageable.getPageSize(), argsArray);
            System.out.println(pageVo);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return pageVo;

    }
    @Override
    public BrandMapperDto findById(String id){
      ProviderProductBrand providerProductBrand =   this.providerProductBrandRepos.findOne(id);
      return mapperFacade.map(providerProductBrand,BrandMapperDto.class);
    }
    @Override
    public Boolean bindStandardBrand(String id , String productBrandId){
        ProviderProductBrand providerProductBrand = this.providerProductBrandRepos.findOne(id);
        if(Lang.isEmpty(providerProductBrand)){
            return false;
        }
        //获取标准品牌名称
        ProductBrandDto productBrandDto = productBrandApi.findByIdAndIsDelete(productBrandId,false);
        if(Lang.isEmpty(productBrandDto)) {
            return false;
        }
        providerProductBrand.setProductBrandId(productBrandId);
        //表示已匹配
        providerProductBrand.setMatchFlag("1");
        //手工匹配
        providerProductBrand.setMatchSource("2");
        providerProductBrand.setProductBrandName(productBrandDto.getName());
        //保存
        this.providerProductBrandRepos.save(providerProductBrand);
        //更新品牌下的model内的标准品牌字段：
        BrandVo brandVo = new BrandVo();
        brandVo.setId(productBrandDto.getId());
        productModelService.updateProviderProductMappingInfo(id,false,brandVo);
        return true;
    }
    @Override
    public Boolean cancelBindStandardBrand(String id){
        ProviderProductBrand providerProductBrand =   this.providerProductBrandRepos.findOne(id);
        if(Lang.isEmpty(providerProductBrand)){
            return false;
        }
        providerProductBrand.setProductBrandId(null);
        providerProductBrand.setMatchFlag("0");
        //未匹配标识
        providerProductBrand.setMatchSource("0");
        providerProductBrand.setProductBrandName(null);
        this.providerProductBrandRepos.save(providerProductBrand);
        BrandVo brandVo = new BrandVo();
        productModelService.updateProviderProductMappingInfo(id,false,brandVo);
        return true;
    }

    private String[] splitName(String initBrand){
        String[] initStrings  = initBrand.split("（|\\(|\\/");
        for (int i=0;i<initStrings.length;i++){
            String str = initStrings[i].trim().replaceAll("\\s+"," ").replaceAll("）|\\)", "");
            initStrings[i] = str;
        }
        return initStrings;
    }

    private List<BrandVo> findProductBrand(String ch_name,String en_name){
        List argList = new ArrayList();
        StringBuffer sb = new StringBuffer();
        List<BrandVo> list = new ArrayList<>();
        if(!Lang.isEmpty(ch_name)||!Lang.isEmpty(en_name)) {
            String selectStr = "select id,name from product_brand pb where 1=1 ";
            sb.append(selectStr);
            if (!Lang.isEmpty(ch_name) && !Lang.isEmpty(en_name)) {
                sb.append(" and ch_name = ? or lower(en_name) = ?");
                argList.add(ch_name);
                argList.add(en_name);
            } else if (!Lang.isEmpty(ch_name)) {
                sb.append(" and ch_name = ? ");
                argList.add(ch_name);
            } else if (!Lang.isEmpty(en_name)) {
                sb.append(" and lower(en_name) = ?");
                argList.add(en_name.toLowerCase());
            } else {
                sb.append(" and 1 = 2");
            }
            sb.append( " and is_delete = ? ");
            argList.add("0");
            list = jdbcTemplate.query(sb.toString(),argList.toArray(),new BeanPropertyRowMapper<>(BrandVo.class));
        }
        return list;
    }

    @Override
    public List<BrandMapperDto> findStores(){
        String querySQL  = " select distinct ppd.store_id as storeId,se.store_name as storeName from provider_product_brand ppd , store_ext se where ppd.store_id = se.store_id";
        List<BrandMapperDto> brandMapperDtoList = jdbcTemplate.query(querySQL,new BeanPropertyRowMapper(BrandMapperDto.class));
        return  brandMapperDtoList;
    }

    @Override
    public ProviderProductBrandVo findBrandByNameAndStoreId(String brandName, String storeId) {
        List<ProviderProductBrand> providerProductBrands = this.providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(brandName,storeId,false);
        if(!Lang.isEmpty(providerProductBrands)){
            return mapperFacade.map(providerProductBrands.get(0),ProviderProductBrandVo.class);
        }
        return null;
    }
    @Override
    public List<String> findStoresOfProviderByProductCategoryId(String productCategoryId){
        String querySql = " select distinct pg.store_id from PROVIDER_PRODUCT_FASHION pg , provider_product ppm where pg.PROVIDER_PRODUCT_ID = ppm.ID and pg.store_id = ppm.store_id and pg.is_delete = ? and ppm.product_category_id = ? ";
        List<String> storeIdList = jdbcTemplate.queryForList(querySql,new Object[]{false,productCategoryId},String.class);
        return storeIdList;
    }

    @Override
    public void updateProviderBrandMappingInfo(BrandVo brandVo) {
        providerProductBrandRepos.updateProviderBrandMappingInfo(brandVo.getId(),brandVo.getName());
    }
}
