package pool.service.service.ServiceImpl;

import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pool.model.ProviderProductCategory;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.service.service.CategoryService;
import pool.vo.ProviderProductCategoryVo;
import utils.Lang;

import java.util.List;

//import pool.payment.model.Category;
//import pool.payment.model.repository.CategoryRepos;

@Component
public class CategoryServiceImpl implements CategoryService {

    private static final Logger logger = LoggerFactory.getLogger(CategoryServiceImpl.class);

//    @Autowired
//    private CategoryRepos categoryRepos;

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;

//    /**
//     * 商品分类动态查询
//     * @param categoryDto
//     * @return
//     */
//    @Override
//    public BaseResponse<PageVo<CategoryVo>> findCategories(CategoryQueryDto categoryDto) {
//        BaseResponse baseResponse = new BaseResponse<>();
//        try {
//            if (!Lang.isEmpty(categoryDto) && Lang.isEmpty(categoryDto.getPageNo())) {
//                categoryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
//            }
//            if (!Lang.isEmpty(categoryDto) && Lang.isEmpty(categoryDto.getPageSize())) {
//                categoryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
//            }
//            if (Lang.isEmpty(categoryDto)) {
//                categoryDto = new CategoryQueryDto();
//                categoryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
//                categoryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
//            }
//            //查询是当前num需要减1作为数据库的查询条件
//            int realPageNo = categoryDto.getPageNo()-1>0 ? categoryDto.getPageNo()-1:0;
//            Pageable pageable = new PageRequest(realPageNo, categoryDto.getPageSize());
//            Category category = new Category();
//            category.setCatClass(categoryDto.getCatClass());
//            category.setParentId(categoryDto.getParentId());
//            Specification<Category> specification = new Specification<Category>(){
//                @Override
//                public Predicate toPredicate(Root<Category> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
//                    List<Predicate> predicates = new ArrayList<>();
//                    if(!Lang.isEmpty(category.getCatClass())){
//                        predicates.add(cb.equal(root.get("catClass"),category.getCatClass()));
//                    }
//                    if(!Lang.isEmpty(category.getParentId())){
//                        predicates.add(cb.equal(root.get("parentId"),category.getParentId()));
//                    }
//                    //添加isDelete=false的限制
//                    predicates.add(cb.equal(root.get("isDelete"),false)); //逻辑删除 true：删除，false：未删除
//                    predicates.add(cb.equal(root.get("sourceCode"),category.getSourceCode())); //限制：查询京东的分类
//                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
//                }
//            };
//            Page<Category> page = categoryRepos.findAll(specification, pageable);
//            List<Category> categoryList = page.getContent();
//            //PO转VO List<Category> 转 List<CategoryVo>
////            List<CategoryVo> categoryVoList = mapperFacade.mapAsList(categoryList,CategoryVo.class);
//            List<CategoryVo> categoryVos = new ArrayList<>();
//            for (Category item : categoryList) {
//                CategoryVo categoryVo = new CategoryVo();
//                categoryVo.setName(item.getName());
//                categoryVo.setCatId(item.getCatId());
//                categoryVo.setParentId(item.getParentId());
//                categoryVo.setCatClass(item.getCatClass());
////                categoryVo.setState(item.getState());
//                categoryVos.add(categoryVo);
//            }
//
//            //返回数据：
//            CategoryPageVo categoryPageVo = new CategoryPageVo(categoryVos,page.getNumber()+1,page.getSize(),page.getTotalElements());
//
//            baseResponse.setResult(categoryPageVo);
//            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
//            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
//            baseResponse.setSuccess(true);
//        } catch (Exception e) {
//            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE,"",MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
//            e.printStackTrace();
//        }
//        return baseResponse;
//    }

    @Override
    public List<ProviderProductCategoryVo> findProviderCategoryByCodeAndStoreId(String code, String storeId) {

        List<ProviderProductCategory> providerProductCategories = providerProductCategoryRepos.findByCodeAndStoreIdAndIsDelete(code,storeId,false);
        if(!Lang.isEmpty(providerProductCategories)) {
            return mapperFacade.mapAsList(providerProductCategories,ProviderProductCategoryVo.class);
        }
        return null;
    }

}
