package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.ProductCategoryApi;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductCategoryDto;
import goods.dto.product.ProductFashionDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperAndLowerQueryDto;
import pool.dto.ProviderGoodsDto;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.GoodsUpperAndLowerService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.JdbcTemplatePage;
import utils.sql.PageVo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@MotanService
@Slf4j
public class GoodsUpperAndLowerServiceImpl implements GoodsUpperAndLowerService {

    private static final Logger logger = LoggerFactory.getLogger(GoodsUpperAndLowerServiceImpl.class);

    @Autowired
    private JdbcTemplatePage jdbcTemplatePage;

    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @MotanReferer
    ProductCategoryApi productCategoryApi;

    @Autowired
    private MapperFacade mapperFacade;

    static final String SORT_FRONTPRICE = "frontPrice";//前台价
    static final String SORT_SALEPRICE = "salePrice";//销售价
    static final String SORT_COSTPRICE = "costPrice";//协议价
    static final String SORT_AGREEMENTDISCOUNTRATE = "agreementDiscountRate";//协议折扣率
    static final String SORT_REALTIMEDISCOUNTRATE = "realTimeDiscountRate";//实时折扣率
    static final String SORT_RATEMODERATE = "rateModeRate";//费率
    static final String ISUP_NOT_SHELF = "0";//未上架
    static final String ISUP_ALREADY_SHELF = "1";//已上架
    static final String PREFERENCE_NO = "0";//否
    static final String PREFERENCE_YES = "1";//是

    /**
     * 商品上下架页面列表查询
     *
     * @param goodsUpperAndLowerQueryDto
     * @return
     */
    @Override
    public BaseResponse<PageVo<GoodsUpperAndLowerDto>> findGoodsUpperAndLowers(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto, int number, int size) {
        long millis = System.currentTimeMillis();
        PageVo<GoodsUpperAndLowerDto> pageVo = null;
        Map<String, Object> sqlListMap = findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            pageVo = jdbcTemplatePage.query(String.valueOf(sqlListMap.get("sql")), GoodsUpperAndLowerDto.class, number, size, (Map<String, Object>) sqlListMap.get("params"));
        } catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse<>(false, "商品列表分页查询失败", pageVo);
        }
        logger.info("jdbcTemplatePage查询列表数据耗时：{}", System.currentTimeMillis() - millis);
        return new BaseResponse<>(true, "商品列表分页查询成功", pageVo);
    }

    /**
     * 商品上下架页面列表查询sql
     *
     * @param goodsUpperAndLowerQueryDto
     * @return
     */
    public Map<String, Object> findGoodsUpperAndLowersSql(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        Map<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String orgCodeStr = "";
        //合作伙伴
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getOrgCode()) && !"all".equals(goodsUpperAndLowerQueryDto.getOrgCode().trim())) {
            orgCodeStr = " and gc.organization_code = :orgcode ";
            params.put("orgcode", goodsUpperAndLowerQueryDto.getOrgCode().trim());
        }
        sql.append(" select  rownum as gIndex, g.* from ")
                .append("    (")
                .append("        SELECT")
                .append("            ppf.category_name AS categoryname,")
                .append("            ppf.provider_name AS providername,")
                .append("            ppf.sku AS sku,")
                .append("            ppf.name AS name,")
                .append("            ppf.brand_name AS brandname,")
                .append("            ppf.market_price AS originalPrice,")
                .append("            ppf.cost_price AS costprice,")
                .append("            gcc.price AS saleprice,")
                .append("            ppf.agreement_discount_rate AS agreementdiscountrate,")
                .append("            ppf.real_time_discount_rate AS realtimediscountrate,")
                .append("            ppf.rate_mode_rate AS ratemoderate,")
                .append("            gcc.is_up AS isup,")
                .append("            gcc.is_preferred AS ispreferred,")
                .append("            ppf.store_id AS storeid,")
                .append("            ppf.category_id as categoryid,")
                .append("            ppf.brand_id as brandid,")
                .append("            gcc.organization_code AS organizationcode ")
                .append("        FROM")
                .append("            provider_product_fashion ppf,")
                .append("           ( select gc.price, gc.is_up, gc.is_preferred, gc.sku, gc.user_id, gc.organization_code ")
                .append("            from  goods_config gc where  gc.is_delete = 0 ")
                .append(orgCodeStr)
                .append("            ) gcc")
                .append("        WHERE")
                .append("                ppf.sku = gcc.sku (+)")
                .append("            AND")
                .append("                ppf.store_id = gcc.user_id (+)")
                .append("            AND")
                .append("                ppf.provider_sale_status = '1'")
                .append("            AND")
                .append("                ppf.is_delete = 0")
                .append("    ) g ")
                .append(" WHERE 1=1 ");

        //上下架状态
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getIsUp()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsUp().trim())) {
            if (ISUP_NOT_SHELF.equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup or g.isup is null)");
            }
            if (ISUP_ALREADY_SHELF.equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup )");
            }
            params.put("isup", goodsUpperAndLowerQueryDto.getIsUp());
        }
        //是否优选
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getIsPreferred()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsPreferred().trim())) {
            if (PREFERENCE_NO.equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and (g.ispreferred = :ispreferred or g.ispreferred is null)");
            }
            if (PREFERENCE_YES.equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and g.ispreferred = :ispreferred ");
            }
            params.put("ispreferred", goodsUpperAndLowerQueryDto.getIsPreferred());
        }
        //销售价
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice <= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :startsaleprice  and g.saleprice <= :endsaleprice ");
            params.put("startsaleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
            params.put("endsaleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        }
        //分类

        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getProductCategoryId())) {
            List<String> threeCategoryId = productCategoryApi.findThreeCategoryByCategoryId(goodsUpperAndLowerQueryDto.getProductCategoryId());
            sql.append(" and g.categoryid  in (:categoryid) ");
            params.put("categoryid", threeCategoryId);
        }
        //供应商SKU
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getSku())) {
            sql.append(" and g.sku = :sku ");
            params.put("sku", goodsUpperAndLowerQueryDto.getSku());
        }
        //供应商
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStoreId()) && !"all".equals(goodsUpperAndLowerQueryDto.getStoreId().trim())) {
            sql.append(" and g.storeid = :storeid ");
            params.put("storeid", goodsUpperAndLowerQueryDto.getStoreId());
        }
        //商品名称
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getName())) {
            sql.append(" and g.name like (:name) ");
            params.put("name", "%" + goodsUpperAndLowerQueryDto.getName() + "%");
        }
        //品牌
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getBrandIds())) {
            List<Object> list = new ArrayList<Object>();
            String[] brandArry = goodsUpperAndLowerQueryDto.getBrandIds().split(",");
            for (String brand : brandArry) {
                list.add(brand);
            }
            sql.append(" and g.brandid in (:brandid) ");
            params.put("brandid", list);
        }
        //协议价
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice <= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :startcostprice  and g.costprice <= :endcostprice ");
            params.put("startcostprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
            params.put("endcostprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        }
        //费率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate <= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :startratemoderate  and g.ratemoderate <= :endratemoderate ");
            params.put("startratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
            params.put("endratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        }
        //协议折扣率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate <= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :startagreementdiscountrate  and g.agreementdiscountrate <= :endagreementdiscountrate ");
            params.put("startagreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
            params.put("endagreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        }
        //实时折扣率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate <= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :startrealtimediscountrate  and  g.realtimediscountrate <= :endrealtimediscountrate ");
            params.put("startrealtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
            params.put("endrealtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        }
        //Todo 排序先不做
        /*if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getSortParam())) {
            //前台价
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_FRONTPRICE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.cost_price ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_FRONTPRICE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.cost_price DESC");
            }
            //销售价
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_SALEPRICE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.sale_price ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_SALEPRICE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.sale_price DESC");
            }
            //协议价
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_COSTPRICE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.cost_price ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_COSTPRICE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.cost_price DESC");
            }
            //协议折扣率
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_AGREEMENTDISCOUNTRATE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.agreement_discount_rate ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_AGREEMENTDISCOUNTRATE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.agreement_discount_rate DESC");
            }
            //实时折扣率
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_REALTIMEDISCOUNTRATE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.real_time_discount_rate ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_REALTIMEDISCOUNTRATE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.real_time_discount_rate DESC");
            }
            //费率
            if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_RATEMODERATE) && "ASC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.rate_mode_rate ASC");
            } else if (goodsUpperAndLowerQueryDto.getSortParam().equals(SORT_RATEMODERATE) && "DESC".equals(goodsUpperAndLowerQueryDto.getSortValue())) {
                sql.append(" order by pg.rate_mode_rate DESC");
            }
        }*/
        log.info("商品上下架页面列表查询sql===》：{}", sql.toString());
        Map<String, Object> map = new HashedMap();
        map.put("sql", sql.toString());
        map.put("params", params);
        return map;
    }

    @Override
    public BaseResponse<List<GoodsUpperAndLowerDto>> findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        List<GoodsUpperAndLowerDto> goodsUpperAndLowerDtos = null;
        Map<String, Object> sqlListMap = findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            goodsUpperAndLowerDtos = namedParameterJdbcTemplate.query(String.valueOf(sqlListMap.get("sql")), (Map<String, Object>) sqlListMap.get("params"), new BeanPropertyRowMapper<GoodsUpperAndLowerDto>(GoodsUpperAndLowerDto.class));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("商品列表查询失败 {}", e);
            return new BaseResponse<>(false, "商品列表查询失败", goodsUpperAndLowerDtos);
        }
        return new BaseResponse<>(true, "商品列表查询成功", goodsUpperAndLowerDtos);
    }

    @Override
    public BaseResponse<Integer> findCountByGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        Integer count = null;
        Map<String, Object> sqlListMap = findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            String sqlCount = "select count(*) from (" + sqlListMap.get("sql") + ")  ";
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            count = namedParameterJdbcTemplate.queryForObject(sqlCount, (Map<String, Object>) sqlListMap.get("params"), Integer.class);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("商品列表查询失败 {}", e);
            return new BaseResponse<>(false, "商品列表查询失败", count);
        }
        return new BaseResponse<>(true, "商品列表查询成功", count);
    }

    @Override
    @Transactional
    public ProviderGoodsDto getGoodsDetailInfo(String sku, String storeId) {
        ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
        return mapperFacade.map(providerProductFashion, ProviderGoodsDto.class);
    }

    @Override
    public BaseResponse editGoodsInfoCompletion(String sku, String storeId, String individuaDescription) {
        ProviderProductFashion providerProductFashion1 = null;
        try {
            ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            providerProductFashion.setIndividuaDescription(individuaDescription);
            providerProductFashion1 = providerProductFashionRepos.save(providerProductFashion);
            productFashionApi.updateIndividuaDescriptionBySkuAndStoreId(sku, storeId, individuaDescription);
            logger.info("商品信息补全成功,sku{},商品个性化信息{}", providerProductFashion1.getSku(), providerProductFashion1.getIndividuaDescription());
            return new BaseResponse<>(true, "商品信息补全成功", providerProductFashion1.getSku());
        } catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse<>(false, "商品信息补全失败", providerProductFashion1.getSku());
        }

    }
}
