package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.vo.*;
import jd.api.service.product.JdProductApi;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import pool.model.repository.ProviderGoodsMqLogRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.JdMqHandleService;

/**
 * 消息接口处理流程改造
 * <p>
 * taofeng
 */
@Slf4j
public class JdMqHandleServiceImpl implements JdMqHandleService {

    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;

    @Autowired
    ProviderGoodsMqLogRepos providerGoodsMqLogRepos;

    @MotanReferer
    JdProductApi jdProductApi;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    private static int STATEZERO = 0;
    private static int STATEONE = 1;
    private static int STATETWO = 2;
    private static String JINGDONG = "jingdong";

    /**
     * 记录日志
     */
//    private void addProviderGoodsMqLog(String sku, String type, String providerName) {
//        try {
//            ProviderGoodsMqLog providerGoodsMqLog = new ProviderGoodsMqLog();
//            providerGoodsMqLog.setSku(sku);
//            providerGoodsMqLog.setType(type);
//            providerGoodsMqLog.setProviderName(providerName);
//            providerGoodsMqLogRepos.save(providerGoodsMqLog);
//        } catch (Exception e) {
//            log.error("SKU {} --- type {} --- 日志保存异常", sku, type, e);
//        }
//    }

    @Override
    public void updatePrice(PriceUpdateMessageVo priceUpdateMessageVo) {
//        priceVOs.forEach(priceVO -> {
//            if (!Lang.isEmpty(priceVO)) {
//                long timerGetSimilarProduct = System.currentTimeMillis();
//                int returnFlag = providerProductFashionRepos.updatePriceBySku(priceVO.getSkuId() + "", priceVO.getPrice(), priceVO.getJdPrice(), new Date());
//                if (STATEZERO == returnFlag) {
//                    log.info("商品SKU {} 价格更新失败", JSON.toJSONString(priceVO.getSkuId()));
//                    addProviderGoodsMqLog(JSON.toJSONString(priceVO.getSkuId()), ProviderGoodsMqLog.UPDATEPRICE, JINGDONG);
//                } else {
//                    log.info("商品SKU {} 价格更新成功 , 耗时 {} ms", JSON.toJSONString(priceVO.getSkuId()), System.currentTimeMillis() - timerGetSimilarProduct);
//                }
//            }
//        });
    }

    @Override
    public void productDelete(ProductDeleteMessageVo productDeleteMessageVo) {
//        messageGetVOs.forEach(messageGetVO -> {
//            if (!Lang.isEmpty(messageGetVO)) {
//                long timerGetSimilarProduct = System.currentTimeMillis();
//                String skuId = messageGetVO.getResult().get("skuId").toString();
//                /*List<GoodsConfigDto> goodsConfigDtoList = goodsConfigApi.findBySkuAndIsDelete(skuId, false);
//                goodsConfigDtoList.forEach(goodsConfigDto -> {
//                    *//**
//                 * 如果“渠道商品池存在”且“手工上架”
//                 * 从渠道商品池中下架，并且上下架查询功能中不显示供应商已下架商品
//                 *//*
//                    if (!Lang.isEmpty(goodsConfigDto) && goodsConfigDto.getIsUp()) {
//                        goodsConfigDto.setIsUp(false);
//                        goodsConfigApi.save(goodsConfigDto);
//                    }
//                });*/
//                int retunFlag = providerProductFashionRepos.updateStateBySku(skuId, STATEZERO, false, new Date());
//                if (STATEZERO == retunFlag) {
//                    log.info("商品SKU {} 删除失败", skuId);
//                    addProviderGoodsMqLog(skuId, ProviderGoodsMqLog.PRODUCTDELETE, JINGDONG);
//                } else {
//                    log.info("商品SKU {} 删除成功 , 耗时 {} ms", skuId, System.currentTimeMillis() - timerGetSimilarProduct);
//                }
//            }
//        });
    }

    @Override
    public void productAdd(ProductAddMessageVo productAddMessageVo) {
//        messageGetVOs.forEach(messageGetVO -> {
//            if (!Lang.isEmpty(messageGetVO)) {
//                long timerGetSimilarProduct = System.currentTimeMillis();
//                String skuId = messageGetVO.getResult().get("skuId").toString();
//                ProductDetailVO productDetail = jdProductApi.getProductDetail(new ProductDetailEntity(Long.parseLong(skuId)));
//                List<ProviderProductFashion> providerGoodsList = providerProductFashionRepos.findBySku(skuId);
//                providerGoodsList.forEach(providerProductFashion -> {
//                    try {
//                        if (Lang.isEmpty(providerProductFashion)) {
//                            providerProductFashion = new ProviderProductFashion();
//                        }
//                        providerProductFashion.setName(productDetail.getName());
//                        providerProductFashion.setIntroduction(productDetail.getIntroduction());
//                        providerProductFashion.setParam(productDetail.getParam());
//                        providerProductFashion.setProductArea(productDetail.getProductArea());
//                        providerProductFashion.setSaleUnit(productDetail.getSaleUnit());
////                        providerProductFashion.setState(productDetail.getState());
//                        providerProductFashion.setUpc(productDetail.getUpc());
//                        providerProductFashion.setWareQD(productDetail.getWareQD());
//                        providerProductFashion.setWeight(productDetail.getWeight());
//                        providerProductFashion.setPushUpDate(new Date());
//                        providerProductFashionRepos.save(providerProductFashion);
//                        log.info("商品SKU {} 新增成功 , 耗时 {} ms", skuId, System.currentTimeMillis() - timerGetSimilarProduct);
//                    } catch (Exception e) {
//                        log.error("商品SKU {} 新增失败", skuId, e);
//                        addProviderGoodsMqLog(skuId, ProviderGoodsMqLog.PRODUCTADD, JINGDONG);
//                    }
//                });
//            }
//        });
    }

    //@Transactional(propagation = Propagation.NOT_SUPPORTED)
    @Override
    public void productDetail(ProductDetailUpdateMessageVo productDetailUpdateMessageVo) {
//        messageGetVOs.forEach(messageGetVO -> {
//            if (!Lang.isEmpty(messageGetVO)) {
//                String skuId = messageGetVO.getResult().get("skuId").toString();
//                ProductDetailVO productDetail = jdProductApi.getProductDetail(new ProductDetailEntity(Long.parseLong(skuId)));
//                List<ProviderProductFashion> providerGoodses = providerProductFashionRepos.findBySku(skuId);
//                providerGoodses.forEach(providerProductFashion -> {
//                    try {
//                        providerProductFashion.setName(productDetail.getName());
//                        providerProductFashion.setIntroduction(productDetail.getIntroduction());
//                        providerProductFashion.setParam(productDetail.getParam());
//                        providerProductFashion.setProductArea(productDetail.getProductArea());
//                        providerProductFashion.setSaleUnit(productDetail.getSaleUnit());
////                        providerProductFashion.setState(productDetail.getState());
//                        providerProductFashion.setUpc(productDetail.getUpc());
//                        providerProductFashion.setWareQD(productDetail.getWareQD());
//                        providerProductFashion.setWeight(productDetail.getWeight());
//                        providerProductFashion.setPushUpDate(new Date());
//                        providerProductFashionRepos.save(providerProductFashion);
//                    } catch (Exception e) {
//                        log.error("商品SKU {} 参数更新失败", skuId, e);
//                        addProviderGoodsMqLog(skuId, ProviderGoodsMqLog.PRODUCTDETAIL, JINGDONG);
//                    }
//                });
//            }
//        });
    }

    @Override
    public void updateSkuStatus(SkuStatusUpdateMessageVo skuStatusUpdateMessageVo) {
//        messageGetVOs.forEach(messageGetVO -> {
//            if (!Lang.isEmpty(messageGetVO)) {
//                String skuId = messageGetVO.getResult().get("skuId").toString();
//                Integer state = (Integer) messageGetVO.getResult().get("state");
//                // state = 0 下架，state = 1 上架
//                int returnFlag = providerProductFashionRepos.updateStateBySku(skuId, state, false, new Date());
//                if (STATEONE == state) {
//                    if (STATEZERO == returnFlag) {
//                        log.info("商品SKU {} 上架失败");
//                        addProviderGoodsMqLog(skuId, ProviderGoodsMqLog.UPDATESKUSTATUS + "--state-" + state, JINGDONG);
//                    } else {
//                        log.info("商品SKU {} 上架成功");
//                    }
//                } else if (STATEZERO == state) {
//                    if (STATEZERO == returnFlag) {
//                        log.info("商品SKU {} 下架失败");
//                        addProviderGoodsMqLog(skuId, ProviderGoodsMqLog.UPDATESKUSTATUS + "--state-" + state, JINGDONG);
//                    } else {
//                        log.info("商品SKU {} 下架成功");
//                    }
//                }
//            }
//        });
    }

}

