package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductApi;
import goods.dto.goods.GoodsConfigDto;
import goods.vo.query.GoodsConfigQuery;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pool.api.ProviderProductModelApi;
import pool.dto.GoodsUpperLowerDto;
import pool.dto.ProviderProductFashionDto;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.GoodsAutosyncFilterService;
import pool.service.service.ProductModelService;
import pool.service.service.ProviderProductFashionService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import java.util.*;

/**
 * taofeng
 * <p>
 * 手动设置优选和上下架的实现
 */
@Slf4j
@Service
public class PreferenceAndUpperShelvesImpl {

    static final Integer GOODS_STATE_UP = 1;
    static final Integer GOODS_STATE_LOW = 0;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @Autowired
    ProductModelService productModelService;
    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;
    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;
    @MotanReferer
    ProductApi productApi;
    @MotanReferer
    GoodsApi goodsApi;

    @Autowired
    ProviderProductFashionService providerProductFashionService;

    @Transactional
    public BaseResponse<List<String>> preferredImpl(List<GoodsUpperLowerDto> goodsUpperLowerDtos, boolean isPreferred, String organizationCode) {

        List<String> returnSku = new ArrayList<>();
        List<String> errSku = new ArrayList<>();
        try {
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                String sku = goodsUpperLowerDto.getSku();
                String storeId = goodsUpperLowerDto.getStoreId();
                goodsConfigQuery.setOrganizationCode(organizationCode);
                goodsConfigQuery.setStoreId(storeId);
                goodsConfigQuery.setSkus((Arrays.asList(sku)));
                List<GoodsConfigDto> configList = goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                configList.forEach(goodsConfig -> {
                    try {
                        if (Lang.isEmpty(goodsConfig.getIsPreferred()) || isPreferred != goodsConfig.getIsPreferred()) {
                            goodsConfig.setIsPreferred(isPreferred);
                            goodsConfigApi.save(goodsConfig);
                            returnSku.add(goodsConfig.getSku());
                        }
                    } catch (Exception e) {
                        errSku.add(goodsConfig.getSku());
                        log.error("-设置优选失败", e);
                    }
                });
            });
        } catch (Exception e) {
            log.error("---操作失败", e);
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
                errSku.add(goodsUpperLowerDto.getSku());
            });
            return new BaseResponse(false, "操作失败", errSku);
        }
        if (Lang.isEmpty(returnSku)) {
            log.info("---设置优选失败,没有操作成功数据,失败的sku:{}", errSku.toString());
            return new BaseResponse(false, "设置优选失败,没有操作成功数据", errSku);
        } else if (Lang.isEmpty(errSku)) {
            log.info("---设置优选全部操作成功");
            return new BaseResponse(true, "设置优选全部操作成功");
        } else {
            log.info("---操作成功,失败的sku:{}", errSku.toString());
            return new BaseResponse(true, "设置优选成功", errSku);
        }
    }

    public BaseResponse<List<String>> goodsUpOrNot(List<GoodsUpperLowerDto> goodsUpperLowerDtos, boolean isUp, String organizationCode) {

        List<Boolean> successSku = new ArrayList<>();
        List<String> errorSku = new ArrayList<>();

        Map<String, List<String>> skuMap = new HashMap<>();
        goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
            String storeId = goodsUpperLowerDto.getStoreId();
            String sku = goodsUpperLowerDto.getSku();
            if (!Lang.isEmpty(skuMap.get(storeId))) {
                skuMap.get(storeId).add(sku);
            } else {
                List<String> skus = new ArrayList<>();
                skus.add(sku);
                skuMap.put(storeId, skus);
            }
        });
        Set<String> storeIds = skuMap.keySet();

        try {
            storeIds.forEach(storeId -> {
                //下架
                if (!isUp) {
                    try {
                        //Boolean state = goodsApi.modifyingGoodsState(GOODS_STATE_LOW, skuMap.get(storeId), storeId, GOODS_STATE_UP, false);
                        goodsConfigApi.artificialDownMallOrganizationGoods(skuMap.get(storeId), storeId, organizationCode);
                        successSku.add(true);
                    } catch (Exception e) {
                        skuMap.get(storeId).forEach(sku -> {
                            errorSku.add(sku);
                        });
                        log.error("-下架失败", e);
                    }
                } else {
                    //上架
                    List<String> upSku = new ArrayList();
                    skuMap.get(storeId).forEach(sku -> {
                        try {
                            //判断商品是否符合上架规则
                            long a2 = System.currentTimeMillis();
                            boolean ifCateUp = productModelService.isSynCateAndBrand(sku, storeId, organizationCode);
                            log.info("判断 sku:{} 是否符合上架规则耗时 {} ms", sku, System.currentTimeMillis() - a2);

                            if (ifCateUp) {
                                long a3 = System.currentTimeMillis();
                                ProviderProductFashionDto providerProductFashionDto = providerProductFashionService.findBySkuAndStoreId(sku, storeId, false);
                                BaseResponse response = productApi.syncProduct(providerProductFashionDto);
                                log.info("sku:{} 信息同步耗时 {} ms", sku, System.currentTimeMillis() - a3);

                                long a4 = System.currentTimeMillis();
                                if (response.isSuccess()) {
                                    String skuSyn = response.getResultCode();
                                    upSku.add(skuSyn);
                                } else {
                                    //商品同步失败
                                    String resultCode = response.getResultCode();
                                    errorSku.add(resultCode);
                                    log.info("sku:{} 信息同步失败", sku);
                                }
                                log.info("a4 {} ", System.currentTimeMillis() - a4);
                            } else {
                                errorSku.add(sku);
                                log.info("sku:{} 不符合上架规则", sku);
                            }
                        } catch (Exception e) {
                            errorSku.add(sku);
                            log.info("sku:{} 上架异常", sku, e);
                        }
                    });
                    try {
                        if (!Lang.isEmpty(upSku)) {
                            long a5 = System.currentTimeMillis();
                            log.info("sku:{} 开始上架", upSku.toString());
                            goodsConfigApi.artificialPutWayMallOrganizationGoods(upSku, storeId, organizationCode);
                            successSku.add(true);
                            log.info("sku:{} 上架耗时 {} ms", upSku.toString(), System.currentTimeMillis() - a5);
                        }
                    } catch (Exception e) {
                        errorSku.addAll(upSku);
                        log.error("sku:{} 执行上架操作失败", upSku.toString(), e);
                    }
                }
            });
        } catch (Exception e) {
            log.error("---操作失败", e);
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
                errorSku.add(goodsUpperLowerDto.getSku());
            });
            return new BaseResponse(false, "操作失败", errorSku);
        }
        if (Lang.isEmpty(successSku)) {
            log.info("---商品上下架失败,没有操作成功数据,失败的sku:{}", errorSku.toString());
            return new BaseResponse(false, "商品上下架失败,没有操作成功数据", errorSku);
        } else if (Lang.isEmpty(errorSku)) {
            log.info("---商品上下架全部成功");
            return new BaseResponse(true, "商品上下架全部成功");
        } else {
            log.info("---商品上下架成功,失败的sku:{}", errorSku.toString());
            return new BaseResponse(true, "商品上下架成功", errorSku);
        }
    }

}
