package pool.service.service.ServiceImpl;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsProductCatgoryApi;
import goods.api.ProductApi;
import goods.api.ProductBrandApi;
import goods.api.ProductCategoryApi;
import goods.dto.product.ProductBrandDto;
import goods.vo.ProductCategoryVo;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pool.api.ProviderProductFashionManagerApi;
import pool.commonUtil.MessageDictionary;
import pool.dto.*;
import pool.dto.enumeration.ProviderProductFashionStatusEnum;
import pool.model.*;
import pool.model.repository.*;
import pool.service.listeners.MqHandleProducer;
import pool.service.service.*;
import pool.service.specification.QueryProviderGoodsSpecification;
import pool.utils.SequenceUtil;
import pool.vo.*;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.sql.PageVo;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.*;
import java.util.concurrent.*;


/**
 * create by zj 2018/07/04
 */
@Slf4j
@Service
public class ProviderGoodsServiceImpl implements ProviderGoodsService {

    @MotanReferer
    ProviderProductFashionManagerApi providerProductFashionManagerApi;
    @MotanReferer
    GoodsProductCatgoryApi goodsProductCatgoryApi;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;

    @Autowired
    private ProviderProductFashionPictureRepos providerProductFashionPictureRepos;
    @Autowired
    private ProviderGoodsSpecificationRepos specificationRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private MqHandleProducer mqHandleProducer;
    @Autowired
    StoreService storeService;
    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;
    @Autowired
    PreferenceAndUpperShelvesImpl preferenceAndUpperShelvesImpl;
    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;
    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    private BrandService brandService;

    @Autowired
    private ProductModelService productModelService;

    @Autowired
    ProviderProductRepos providerProductRepos;
    @MotanReferer
    ProductCategoryApi productCategoryApi;
    @MotanReferer
    ProductBrandApi productBrandApi;
    @Autowired
    ProviderProductFashionService providerProductFashionService;

    @MotanReferer
    ProductApi productApi;
    @Autowired
    OrganizationApiStub organizationApiStub;

    @Autowired
    SequenceUtil sequenceUtil;

    @Autowired
    ProviderProductFashionTransactionService providerProductFashionTransactionService;

    @MotanReferer
    OrderMainApi orderMainApi;

    private static String ALL = "all";
    static final String ISUP_NOT_SHELF = "0";//未上架
    static final String ISUP_ALREADY_SHELF = "1";//已上架
    static final String PREFERENCE_NO = "0";//否
    static final String PREFERENCE_YES = "1";//是
    static final String JICAI = "jicai";
    static final String UNINOGIFT = "uninogift";
    static final int NOT_ON_SALE = 0;
    static final String JDCODE = "jingdong";
    @Autowired
    RedisTemplate redisTemplate;

    private static String ZERO = "0";
    private static String ONE = "1";
    private static String ISPREFERRED = "0";
    private static String DISPREFERRED = "1";
    private static String ISUP = "2";
    private static String DISUP = "3";
    private static String STORE_LOCAL = "7";

    @Override
    public BaseResponse saveProviderGoods(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            List<Integer> invoiceTypeList = Arrays.asList(MessageDictionary.INVOICE_TYPE_ARRAY);
            BaseResponse result = validateGoods(providerGoodsDto);
            if (result != null) {
                log.info("-------------saveProviderGoods,创建商品返回节点1：(result != null)-------------");
                return result;
            }

            //拷贝
            ProviderProductFashion providerProductFashion = mapperFacade.map(providerGoodsDto, ProviderProductFashion.class);
            //新增前，根据sku和storeId判断商品是否已经存在
            ProviderProductFashion ppf = new ProviderProductFashion();
            ppf.setSku(providerProductFashion.getSku());
            ppf.setStoreId(providerProductFashion.getStoreId());
            ppf.setIsDelete(false);
            boolean goodsExist = providerProductFashionRepos.exists(Example.of(ppf));
            if (goodsExist) {
                log.info("-------------saveProviderGoods,创建商品返回节点2：(goodsExist)-------------");
                return new BaseResponse(false, MessageDictionary.RETURN_ALREADY_EXIST_PROVIDER_PRODUCT_MESSAGE, "",
                        MessageDictionary.RETURN_ALREADY_EXIST_OBJECT_CODE);
            }

            //新增商品图片设置
            for (ProviderProductFashionPicture pic : providerProductFashion.getPics()) {
                pic.setProviderProductFashion(providerProductFashion);
            }
            //设置是否支持售后，是否支持开具发票,是否支持7天无条件退货的默认值
            //是否支持售后
            if (Lang.isEmpty(providerProductFashion.getPostSalePolicy())) {
                providerProductFashion.setPostSalePolicy(1);
            }
            //是否支持开具发票
            if (Lang.isEmpty(providerProductFashion.getInvoiceType()) || !invoiceTypeList.contains(providerProductFashion.getInvoiceType())) {
                providerProductFashion.setInvoiceType(MessageDictionary.PROVIDER_PRODUCT_INVOICE_TYPE_DEFAULT);
            }
            if (!Lang.isEmpty(providerProductFashion.getProviderGoodsSpecifications())) {
                List<ProviderGoodsSpecification> specs = providerProductFashion.getProviderGoodsSpecifications();
                for (ProviderGoodsSpecification spec : specs) {
                    spec.setProviderProductFashion(providerProductFashion);
                }
                providerProductFashion.setProviderGoodsSpecifications(specs);
            }
            if (!Lang.isEmpty(providerProductFashion.getModelSku())) {
                //供应商推送商品，先有model再创建商品
                ProviderProduct productModel = providerProductRepos.findByModelSkuAndStoreIdAndIsDelete(providerProductFashion.getModelSku(),
                        providerProductFashion.getStoreId(), false);
                if (!Lang.isEmpty(productModel)) {
                    providerProductFashion.setProviderProduct(productModel);
                    // 设置分类、品牌属性
                    if (!Lang.isEmpty(productModel.getCategoryId())) {
                        ProductCategoryVo productCategoryVo = productCategoryApi.findByIdAndIsDelete(productModel.getCategoryId());
                        if (!Lang.isEmpty(productCategoryVo)) {
                            providerProductFashion.setCategoryId(productCategoryVo.getId());
                            providerProductFashion.setCategoryName(productCategoryVo.getName());
                        }
                    }
                    if (!Lang.isEmpty(productModel.getProductBrandId())) {
                        ProductBrandDto productBrandDto = productBrandApi.findByIdAndIsDelete(productModel.getProductBrandId(), false);
                        if (!Lang.isEmpty(productBrandDto)) {
                            providerProductFashion.setBrandId(productBrandDto.getId());
                            providerProductFashion.setBrandName(productBrandDto.getName());
                        }
                    }

                } else {
                    log.info("-------------saveProviderGoods,创建商品返回节点3：modelSku错误-------------");
                    return new BaseResponse(false, "modelSku错误",
                            "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
                }
            } else {
                providerProductFashion = savaProductModel(providerProductFashion, providerGoodsDto);
            }

            StoreDto storeDto = storeService.getStoreByStoreId(providerGoodsDto.getStoreId());
            providerProductFashion.setProvideName(storeDto.getStoreExt().getStoreName());
            if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {
                providerProductFashion.setProviderSaleStatus(Integer.parseInt(ISUP_NOT_SHELF));
            }
            ProviderProductFashion resultGoods = providerProductFashionRepos.save(providerProductFashion);
            //拷贝
            ProviderGoodsDto resultGoodsDto = mapperFacade.map(resultGoods, ProviderGoodsDto.class);

            //本地店铺数据不自动同步
            if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {

                log.info("----------------------saveProviderGoods：本地店铺数据不自动同步-----------------------");
                baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
                baseResponse.setSuccess(true);
                baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
                baseResponse.setResult(resultGoodsDto);
                return baseResponse;
            }

            List<String> skus = new ArrayList<>();
            skus.add(providerGoodsDto.getSku());
            //是否自动上架,分类品牌是否映射
            Map map = goodsAutosyncFilterService.autoUpCategoryBrandMappingFilter(skus, providerGoodsDto.getStoreId());
            //分类品牌已映射的数据
            List<String> upSuccessMsgList = (List<String>) map.get("upSuccessMsgList");
            if (!Lang.isEmpty(upSuccessMsgList)) {

                List<OrganizationDto> organizationDtos = organizationApiStub.findOrganizationAll();
                for (String sku : upSuccessMsgList) {
                    List<String> upSkuList = new ArrayList<>();
                    Map rsp = goodsAutosyncFilterService.autoUpCategoryOrgUpFilter(sku, providerGoodsDto.getStoreId(), organizationDtos);
                    List<String> orgCodes = (List<String>) rsp.get("organizationList");
                    try {
                        //同步数据
                        if (!Lang.isEmpty(orgCodes)) {
                            ProviderProductFashionDto providerProductFashionDto = providerProductFashionService.findBySkuAndStoreId(sku, providerGoodsDto.getStoreId(), false);
                            BaseResponse<String> autoBaseResponse = productApi.syncProduct(providerProductFashionDto);
                            if (autoBaseResponse.isSuccess()) {
                                List<String> skuList = new ArrayList<>();
                                skuList.add(sku);
                                providerProductFashionRepos.updateStateBySkuBatch(skuList, Integer.valueOf(ProviderGoodsStatus.UPDOWN_STATUS_UP), new Date(), providerGoodsDto.getStoreId());
                                upSkuList.add(sku);

                                //向销售服务推送上架消息
                                for (String orgCode : orgCodes) {
                                    mqHandleProducer.sendSkuUpMessage(upSkuList, providerGoodsDto.getStoreId(), orgCode);
                                }

                            }
                        }

                    } catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                log.info("商品不满足自动上架规则");
            }
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            baseResponse.setResult(resultGoodsDto);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        return baseResponse;
    }

    private BaseResponse validateGoods(ProviderGoodsDto providerGoodsDto) {
        if (Lang.isEmpty(providerGoodsDto)) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }

        if (Lang.isEmpty(providerGoodsDto.getName())) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_NAME_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        if (Lang.isEmpty(providerGoodsDto.getSku())) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_SKU_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
//            if (Lang.isEmpty(providerGoodsDto.getModelSku())) {
//                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_MODELSKU_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
//            }
        if (Lang.isEmpty(providerGoodsDto.getPics())) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_PICS_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        if (Lang.isEmpty(providerGoodsDto.getCostPrice())) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_COSTPRICE_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        if (Lang.isEmpty(providerGoodsDto.getMarketPrice())) {
            return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_MARKETPRICE_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        return null;
    }

    @Transactional
    public ProviderProductFashion savaProductModel(ProviderProductFashion providerProductFashion, ProviderGoodsDto providerGoodsDto) {
        ProviderProduct providerProduct = new ProviderProduct();
        providerProduct.setStoreId(providerProductFashion.getStoreId());

        providerProduct.setModelSku(providerProductFashion.getSku());
        providerProduct.setName(providerProductFashion.getName());

        ProviderProductCategory providerProductCategoryThree = null;
        ProviderProductCategory providerProductCategoryTwo = null;
        ProviderProductCategory providerProductCategoryOne = null;

        ProviderCategoryDto pcd = providerGoodsDto.getProviderCategoryDto();
        if (!Lang.isEmpty(pcd)) {
            //查询三级分类
            if (!Lang.isEmpty(pcd.getThdLevelCode())) {
                providerProductCategoryThree = providerProductCategoryRepos.findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getThdLevelCode(), 3, providerGoodsDto.getStoreId(), false);
            }
            if (!Lang.isEmpty(providerProductCategoryThree)) {
                providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
                providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());
            } else {
                //查询二级分类
                if (!Lang.isEmpty(pcd.getSecLevelCode())) {
                    providerProductCategoryTwo = providerProductCategoryRepos
                            .findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getSecLevelCode(), 2, providerGoodsDto.getStoreId(), false);
                }
                if (!Lang.isEmpty(providerProductCategoryTwo)) {
                    if (!Lang.isEmpty(pcd.getThdLevelName()) && !Lang.isEmpty(pcd.getThdLevelCode())) {
                        providerProductCategoryThree = new ProviderProductCategory();
                        providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                        providerProductCategoryThree.setName(pcd.getThdLevelName());
                        providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                        providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                        providerProductCategoryThree.setLayerIndex(3);
                        providerProductCategoryThree.setParent(providerProductCategoryTwo);
                        providerProductCategoryRepos.save(providerProductCategoryThree);

                    }
                } else {
                    //查询一级分类
                    if (!Lang.isEmpty(pcd.getFstLevelCode())) {
                        providerProductCategoryOne = providerProductCategoryRepos
                                .findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getFstLevelCode(), 1, providerGoodsDto.getStoreId(), false);
                    }
                    if (!Lang.isEmpty(providerProductCategoryOne)) {
                        if (!Lang.isEmpty(pcd.getSecLevelCode()) && !Lang.isEmpty(pcd.getSecLevelName())) {

                            providerProductCategoryTwo = new ProviderProductCategory();
                            providerProductCategoryTwo.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                            providerProductCategoryTwo.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getSecLevelName());
                            providerProductCategoryTwo.setLayerIndex(2);
                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                            providerProductCategoryTwo = providerProductCategoryRepos.save(providerProductCategoryTwo);
                        }

                        if (!Lang.isEmpty(pcd.getThdLevelCode()) && !Lang.isEmpty(pcd.getThdLevelName())) {

                            providerProductCategoryThree = new ProviderProductCategory();
                            providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                            providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                            providerProductCategoryThree.setLayerIndex(3);
                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                            providerProductCategoryRepos.save(providerProductCategoryThree);
                        }
                    } else {
                        if (!Lang.isEmpty(pcd.getFstLevelCode()) && !Lang.isEmpty(pcd.getFstLevelName())) {

                            providerProductCategoryOne = new ProviderProductCategory();
                            providerProductCategoryOne.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryOne.setName(pcd.getFstLevelName());
                            providerProductCategoryOne.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getFstLevelName());
                            providerProductCategoryOne.setLayerIndex(1);
                            providerProductCategoryOne.setCode(pcd.getFstLevelCode());
                            providerProductCategoryOne = providerProductCategoryRepos.save(providerProductCategoryOne);
                        }

                        if (!Lang.isEmpty(pcd.getSecLevelCode()) && !Lang.isEmpty(pcd.getSecLevelName())) {

                            providerProductCategoryTwo = new ProviderProductCategory();
                            providerProductCategoryTwo.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                            providerProductCategoryTwo.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getSecLevelName());
                            providerProductCategoryTwo.setLayerIndex(2);
                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                            providerProductCategoryTwo = providerProductCategoryRepos.save(providerProductCategoryTwo);
                        }

                        if (!Lang.isEmpty(pcd.getThdLevelCode()) && !Lang.isEmpty(pcd.getThdLevelName())) {

                            providerProductCategoryThree = new ProviderProductCategory();
                            providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                            providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                            providerProductCategoryThree.setLayerIndex(3);
                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                            providerProductCategoryRepos.save(providerProductCategoryThree);
                        }
                    }

                }

            }
            providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
            providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());

        }

        ProviderProductBrand brand = null;
        if (!Lang.isEmpty(providerGoodsDto.getBrandName())) {

            List<ProviderProductBrand> providerProductBrands = providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(providerGoodsDto.getBrandName(), providerGoodsDto.getStoreId(), false);
            if (!Lang.isEmpty(providerProductBrands)) {
                brand = providerProductBrands.get(0);
                providerProduct.setProductBrandId(brand.getProductBrandId());
                providerProduct.setBrandId(brand.getId());
            } else {
                //创建品牌
                BrandDto brandDto = new BrandDto();
                brandDto.setName(providerGoodsDto.getBrandName());
                brandDto.setStoreId(providerGoodsDto.getStoreId());
                brandDto.setSimpleName(providerGoodsDto.getBrandName());
                BaseResponse<Map<String, String>> response = brandService.saveBrand(brandDto);
                if (response.isSuccess()) {
                    Map<String, String> map = response.getResult();
                    brand = providerProductBrandRepos.findOne(map.get("brandId"));
                    providerProduct.setProductBrandId(brand.getProductBrandId());
                    providerProduct.setBrandId(brand.getId());
                }
            }
        }

        providerProduct = providerProductRepos.save(providerProduct);
        providerProductFashion.setProviderProduct(providerProduct);
        if (!Lang.isEmpty(providerProduct.getCategoryId())) {
            providerProductFashion.setCategoryId(providerProduct.getCategoryId());
            ProductCategoryVo pcv = productCategoryApi.findByIdAndIsDelete(providerProduct.getCategoryId());
            if (pcv != null) {
                providerProductFashion.setCategoryName(pcv.getName());
            }
        }
        if (!Lang.isEmpty(providerProduct.getProductBrandId())) {
            providerProductFashion.setBrandName(brand.getProductBrandName());
            providerProductFashion.setBrandId(brand.getProductBrandId());
        }
        providerProductFashion.setModelSku(providerGoodsDto.getSku());
        return providerProductFashion;
    }


    @Override
    @Transactional
    public BaseResponse queryProviderGoods(String sku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty(sku)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_SKU_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (Lang.isEmpty(storeId)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NO_STORE_ID_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            ProviderGoodsVo providerGoodsVo = mapperFacade.map(providerProductFashion, ProviderGoodsVo.class);

            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            baseResponse.setResult(providerGoodsVo);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }

        return baseResponse;
    }

    /**
     * 1.根据sku和storeId查询修改的商品是否存在,不存在直接返回
     * 2.存在,将修改数据拷贝到查询出的商品上
     * 3.新图片替换旧图片，将旧图片删除
     * 4.保存
     *
     * @param providerGoodsDto
     * @return
     */
    @Override
    public BaseResponse updateProviderGoods(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse = null;
        try {
            if (Lang.isEmpty(providerGoodsDto)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }

            if (Lang.isEmpty(providerGoodsDto.getName())) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_NAME_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (Lang.isEmpty(providerGoodsDto.getSku())) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_SKU_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }

            List<ProviderProductFashion> providerProductFashion_destinationList = providerProductFashionRepos.
                    findBySkuAndStoreIdAndIsDelete(providerGoodsDto.getSku(), providerGoodsDto.getStoreId(), false);
            if (Lang.isEmpty(providerProductFashion_destinationList)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NO_EXIST_PROVIDER_PRODUCT_MESSAGE, "",
                        MessageDictionary.RETURN_NO_EXIST_OBJECT_CODE);
            }

            ProviderProductFashion providerProductFashion_destination = providerProductFashion_destinationList.get(0);
            providerProductFashion_destination.setName(providerGoodsDto.getName());
            providerProductFashion_destination.setBrandName(providerGoodsDto.getBrandName());
            providerProductFashion_destination.setIntroduction(providerGoodsDto.getIntroduction());
            providerProductFashion_destination.setParam(providerGoodsDto.getParam());
            providerProductFashion_destination.setProductArea(providerGoodsDto.getProductArea());
            providerProductFashion_destination.setSaleUnit(providerGoodsDto.getSaleUnit());
            if(!Lang.isEmpty(providerGoodsDto.getStatus())){
                providerProductFashion_destination.setProviderSaleStatus(Integer.valueOf(providerGoodsDto.getStatus()));
            }
            providerProductFashion_destination.setUpc(providerGoodsDto.getUpc());
            providerProductFashion_destination.setWareQD(providerGoodsDto.getWareQD());
            providerProductFashion_destination.setWeight(providerGoodsDto.getWeight());
            providerProductFashion_destination.setPushUpDate(new Date());

            List<ProviderProductFashionPicture> providerProductFashionPictureList = providerProductFashionPictureRepos.findAllByProviderProductFashion(providerProductFashion_destination);
            List<ProviderGoodsSpecification> specs =specificationRepos.findAllByProviderProductFashion(providerProductFashion_destination);

            //更新图片
            if (!Lang.isEmpty(providerGoodsDto.getPics())) {
                for (ProviderProductFashionPicture providerProductFashionPicture : providerProductFashionPictureList) {
                    providerProductFashionPictureRepos.delete(providerProductFashionPicture);
                }

                List<ProviderProductFashionPicture> pics = mapperFacade.mapAsList(providerGoodsDto.getPics(), ProviderProductFashionPicture.class);

                for (ProviderProductFashionPicture pic : pics) {
                    pic.setProviderProductFashion(providerProductFashion_destination);
                }
                providerProductFashion_destination.setPics(pics);
            }

            //更新规格
            if (!Lang.isEmpty(providerGoodsDto.getProviderGoodsSpecifications())) {
                for (ProviderGoodsSpecification spec : specs) {
                    specificationRepos.delete(spec);
                }

                List<ProviderGoodsSpecification> specList = mapperFacade.mapAsList(providerGoodsDto.getProviderGoodsSpecifications(), ProviderGoodsSpecification.class);
                for (ProviderGoodsSpecification spec : specList) {
                    spec.setProviderProductFashion(providerProductFashion_destination);
                }
                providerProductFashion_destination.setProviderGoodsSpecifications(specList);
            }
            providerProductFashionRepos.save(providerProductFashion_destination);

            baseResponse = new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, null, MessageDictionary.RETURN_SUCCESS_CODE);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE);
        }
        if (baseResponse.isSuccess()) {
            StoreDto storeDto = storeService.getStoreByStoreId(providerGoodsDto.getStoreId());
            mqHandleProducer.sendProductDetailMessage(providerGoodsDto, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }

    /**
     * 修改 增加部分查询参数
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public BaseResponse queryProviderGoodsPage(ProductQueryDto productQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty(productQueryDto) && Lang.isEmpty(productQueryDto.getPageNo())) {
                productQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            if (!Lang.isEmpty(productQueryDto) && Lang.isEmpty(productQueryDto.getPageSize())) {
                productQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            if (Lang.isEmpty(productQueryDto)) {
                productQueryDto = new ProductQueryDto();
                productQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
                productQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            int pageNo = productQueryDto.getPageNo();
            int pageSize = productQueryDto.getPageSize();
            //查询时页码数 -1
            int realPageNo = pageNo;

            Sort sort = new Sort(Sort.Direction.DESC, ProviderProductFashion_.dateCreated.getName());//dateCreated
            Pageable pageable = new PageRequest(realPageNo, pageSize, sort);

            QueryProviderGoodsSpecification specification = new QueryProviderGoodsSpecification(productQueryDto, false);
            Page<ProviderProductFashion> page = providerProductFashionRepos.findAll(specification, pageable);
            List<ProviderProductFashion> providerProductFashionList = page.getContent();
            //PO转VO
            List<ProviderGoodsVo> providerGoodsVoList = mapperFacade.mapAsList(providerProductFashionList, ProviderGoodsVo.class);
            //返回结果页码数 +1
            PageVo<ProviderGoodsVo> pageVo = new PageVo();
            pageVo.setResult(providerGoodsVoList);
            long totalElements = page.getTotalElements();
            pageVo.setTotalCount((int) totalElements);
            pageVo.setPageNum(page.getNumber());
            pageVo.setPageSize(page.getSize());
            //ProviderProductPageVo providerProductPageVo = new ProviderProductPageVo(providerGoodsVoList, page.getNumber() + 1, page.getSize(), page.getTotalElements());
            baseResponse.setResult(pageVo);
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            baseResponse.setSuccess(true);
        } catch (Exception e) {
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, null, MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @Override
//    @Transactional
    public BaseResponse updateGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId) {
        BaseResponse baseResponse = null;
        List<ProductReturnVo> successReturnList = new ArrayList();
        List<ProductReturnVo> failReturnList = new ArrayList();
        //下架数据
        List<String> downList = new ArrayList<>();
        //上架数据
        List<String> upList = new ArrayList<>();
        try {
            //参数错误
            if (Lang.isEmpty(providerGoodsStatusList)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            //查询条件越界
            if (providerGoodsStatusList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE,
                        "", MessageDictionary.RETURN_NOT_IN_RANGE_CODE);
            }
            List<String> statusList = Arrays.asList("1", "0");
            for (ProviderGoodsStatus pgs : providerGoodsStatusList) {
                //请求参数缺失
                if (Lang.isEmpty(pgs.getSku()) || Lang.isEmpty(pgs.getStatus())) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(pgs.getSku(),
                            MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE, MessageDictionary.RETURN_ERROR_MESSAGE);
                    failReturnList.add(productReturnVo);
                    continue;
                }
                //状态码是否只是"0","1"，参数错误
                if (!statusList.contains(pgs.getStatus())) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(pgs.getSku(),
                            MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE, MessageDictionary.RETURN_ERROR_MESSAGE);
                    failReturnList.add(productReturnVo);
                    continue;
                }

                if (ProviderGoodsStatus.UPDOWN_STATUS_UP.equals(pgs.getStatus())) {
                    upList.add(pgs.getSku());
                } else {
                    downList.add(pgs.getSku());
                }
            }

            if (!Lang.isEmpty(downList)) {
                //推送商品下架消息
                providerProductFashionRepos.updateStateBySkuBatch(downList, Integer.valueOf(ProviderGoodsStatus.UPDOWN_STATUS_DOWN), new Date(), storeId);
                log.info("商品下架消息推送：{}", downList.toString());
                for (String sku : downList) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(sku,
                            MessageDictionary.RETURN_SUCCESS_CODE, MessageDictionary.RETURN_SUCCESS_MESSAGE);
                    successReturnList.add(productReturnVo);
                }
                mqHandleProducer.sendSkuDownMessage(downList, storeId);
            }

            StoreDto storeDto = storeService.getStoreByStoreId(storeId);

            if (!Lang.isEmpty(upList)) {

                //自营本地店铺上架,不同步到各商城
                if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {
                    providerProductFashionRepos.updateStateBySkuBatch(upList, Integer.valueOf(ProviderGoodsStatus.UPDOWN_STATUS_UP), new Date(), storeId);

                    for (String sku : upList) {
                        ProductReturnVo productReturnVo = new ProductReturnVo(sku,
                                MessageDictionary.RETURN_SUCCESS_CODE, MessageDictionary.RETURN_SUCCESS_MESSAGE);
                        successReturnList.add(productReturnVo);
                    }

                    ProductUpdateResult productUpdateResult = new ProductUpdateResult(successReturnList, failReturnList);
                    return new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, productUpdateResult, MessageDictionary.RETURN_SUCCESS_CODE);

                }

                Map map = goodsAutosyncFilterService.autoUpCategoryBrandMappingFilter(upList, storeId);
                //上架数据：分类品牌已映射的数据
                List<String> upSuccessMsgList = (List<String>) map.get("upSuccessMsgList");

                //上架数据：分类品牌未映射的数据 上架失败
                List<String> upFailList = (List<String>) map.get("upFailList");
                if (!Lang.isEmpty(upFailList)) {
                    for (int i = 0; i < upFailList.size(); i++) {
                        ProductReturnVo productReturnVo = new ProductReturnVo(upFailList.get(i), MessageDictionary.RETURN_ERROR_CODE, "分类或品牌未映射");
                        failReturnList.add(productReturnVo);
                    }
                }

                //需要上架处理的列表
                if (!Lang.isEmpty(upSuccessMsgList)) {
                    List<OrganizationDto> organizationDtos = organizationApiStub.findOrganizationAll();
                    for (String sku : upSuccessMsgList) {
                        List<String> upSkuList = new ArrayList<>();
                        Map rsp = goodsAutosyncFilterService.autoUpCategoryOrgUpFilter(sku, storeId, organizationDtos);
                        List<String> orgCodes = (List<String>) rsp.get("organizationList");
                        try {
                            //同步数据
                            if (!Lang.isEmpty(orgCodes)) {

                                ProviderProductFashionDto providerProductFashionDto = providerProductFashionService.findBySkuAndStoreId(sku, storeId, false);
                                BaseResponse<String> autoBaseResponse = productApi.syncProduct(providerProductFashionDto);
                                if (autoBaseResponse.isSuccess()) {
                                    ProductReturnVo productReturnVo = new ProductReturnVo(sku, MessageDictionary.RETURN_SUCCESS_CODE, MessageDictionary.RETURN_SUCCESS_MESSAGE);
                                    successReturnList.add(productReturnVo);
                                    List<String> skuList = new ArrayList<>();
                                    skuList.add(sku);
                                    providerProductFashionRepos.updateStateBySkuBatch(skuList, Integer.valueOf(ProviderGoodsStatus.UPDOWN_STATUS_UP), new Date(), storeId);
                                    upSkuList.add(sku);

                                    //向销售服务推送上架消息
                                    for (String orgCode : orgCodes) {
                                        mqHandleProducer.sendSkuUpMessage(upSkuList, storeId, orgCode);
                                    }

                                } else {
                                    ProductReturnVo productReturnVo = new ProductReturnVo(sku, MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE, "同步商品失败");
                                    failReturnList.add(productReturnVo);
                                }
                            } else {
                                log.info("商品sku:{},在任何商城都不满足自动上架（分类上架）规则");
                                ProductReturnVo productReturnVo = new ProductReturnVo(sku, MessageDictionary.RETURN_ERROR_CODE,
                                        "商品不满足上架规则，分类未上架");
                                failReturnList.add(productReturnVo);
                            }

                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                            ProductReturnVo productReturnVo = new ProductReturnVo(sku, MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE,
                                    MessageDictionary.RETURN_ERROR_MESSAGE);
                            failReturnList.add(productReturnVo);
                        }
                    }

                } else {
                    log.info("商品不满足自动上架规则");
                }
            }

            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successReturnList, failReturnList);
            baseResponse = new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, productUpdateResult, MessageDictionary.RETURN_SUCCESS_CODE);

        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }

        return baseResponse;
    }


    @Override
    public BaseResponse updateGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId) {
        BaseResponse baseResponse = null;
        List<ProviderGoodsPrice> successMsgList = new ArrayList<>();
        try {
            if (Lang.isEmpty(providerGoodsPriceList)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (providerGoodsPriceList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_NOT_IN_RANGE_CODE);
            }
            List<ProductReturnVo> successList = new ArrayList();
            List<ProductReturnVo> failList = new ArrayList();

            for (ProviderGoodsPrice providerGoodsPrice : providerGoodsPriceList) {
                if (Lang.isEmpty(providerGoodsPrice.getSku()) || Lang.isEmpty(providerGoodsPrice.getCostPrice())
                        || Lang.isEmpty(providerGoodsPrice.getMarketPrice())) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(),
                            MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE, MessageDictionary.RETURN_ERROR_MESSAGE);
                    failList.add(productReturnVo);
                    continue;
                }

                //先判断sku和storeId 更改对象存不存在
                ProviderProductFashion ppf = new ProviderProductFashion();
                ppf.setSku(providerGoodsPrice.getSku());
                ppf.setStoreId(storeId);
                ppf.setIsDelete(false);
                boolean goodsExist = providerProductFashionRepos.exists(Example.of(ppf));

                if (!goodsExist) {
                    log.info("sku：{},store:{}不存在", providerGoodsPrice.getSku(), storeId);
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(),
                            MessageDictionary.RETURN_NO_EXIST_OBJECT_CODE, MessageDictionary.RETURN_ERROR_MESSAGE);
                    failList.add(productReturnVo);
                    continue;
                }
                try {
                    //更改价格
                    providerProductFashionRepos.updatePriceBySku(providerGoodsPrice.getSku(), providerGoodsPrice.getCostPrice(),
                            providerGoodsPrice.getMarketPrice(), new Date(), storeId);

                } catch (Exception e) {
                    e.printStackTrace();
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(),
                            MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE, MessageDictionary.RETURN_ERROR_MESSAGE);
                    failList.add(productReturnVo);
                }

                ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(),
                        MessageDictionary.RETURN_SUCCESS_CODE, MessageDictionary.RETURN_SUCCESS_MESSAGE);
                successList.add(productReturnVo);
                successMsgList.add(providerGoodsPrice);
            }

            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successList, failList);
            baseResponse = new BaseResponse(true, MessageDictionary.RETURN_SUCCESS_MESSAGE, productUpdateResult,
                    MessageDictionary.RETURN_SUCCESS_CODE);

        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }

        //价格处理成功后向销售商品服务推送价格变更消息
        if (!Lang.isEmpty(successMsgList)) {
            StoreDto storeDto = storeService.getStoreByStoreId(storeId);
            mqHandleProducer.sendPriceUpdateMessage(successMsgList, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }


    @Override
    public BaseResponse updateGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId) {
        BaseResponse baseResponse = null;
        List<ProductReturnVo> successList = null;
        List<ProductReturnVo> failList = null;
        try {
            if (Lang.isEmpty(providerGoodsStockList)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (providerGoodsStockList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE, "", MessageDictionary.RETURN_NOT_IN_RANGE_CODE);
            }

            successList = new ArrayList();
            failList = new ArrayList();

            for (ProviderGoodsStock providerGoodsStock : providerGoodsStockList) {
                if (Lang.isEmpty(providerGoodsStock.getSku()) || Lang.isEmpty(providerGoodsStock.getStockCount())) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE, "error");
                    failList.add(productReturnVo);
                    continue;
                }
                //先判断sku和storeId 更改对象存不存在
                ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOneBySkuAndStoreId(providerGoodsStock.getSku(), storeId);
                if (Lang.isEmpty(providerProductFashion)) {
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), MessageDictionary.RETURN_NO_EXIST_OBJECT_CODE, "error");
                    failList.add(productReturnVo);
                    continue;
                }

                try {
                    //更改库存
                    providerProductFashion.setStockCount(providerGoodsStock.getStockCount());
                    providerProductFashionRepos.save(providerProductFashion);

                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), "0000", "success");
                    successList.add(productReturnVo);
                } catch (Exception e) {
                    e.printStackTrace();
                    ProductReturnVo productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE, "error");
                    failList.add(productReturnVo);
                }
            }
            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successList, failList);
            baseResponse = new BaseResponse(true, "操作成功", productUpdateResult, "0000");
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<List<ProviderGoodsVo>> queryGoods(List<String> skus, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (skus.size() == 0) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_SKU_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            if (Lang.isEmpty(storeId)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NO_STORE_ID_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            List<ProviderProductFashion> providerProductFashionList = providerProductFashionRepos.findBySkusAndStoreId(skus, storeId);
            List<ProviderGoodsVo> providerGoodsVoList = new ArrayList<>();

            for (ProviderProductFashion p : providerProductFashionList) {
                ProviderGoodsVo providerGoodsVo = new ProviderGoodsVo();
                providerGoodsVo.setSku(p.getSku());
                if (p.getProviderSaleStatus() == 1) {
                    providerGoodsVo.setStatus("1");
                }
                if (p.getProviderSaleStatus() == 0) {
                    providerGoodsVo.setStatus("0");
                }
                providerGoodsVo.setProductId(p.getId());
                providerGoodsVo.setCostPrice(p.getCostPrice());
                providerGoodsVo.setSalePrice(p.getSalePrice());
                providerGoodsVo.setMarketPrice(p.getMarketPrice());
                providerGoodsVo.setStockCount(p.getStockCount());
                providerGoodsVoList.add(providerGoodsVo);
            }
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            baseResponse.setResult(providerGoodsVoList);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "", MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }
        return baseResponse;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo) {
        BaseResponse baseResponse = new BaseResponse();
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("LocalOccupyStock:OrderNo" + localStoreOrderVo.getOrderNo() + '4');
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1, TimeUnit.MILLISECONDS);
            if (Lang.isEmpty(localStoreOrderVo)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ORDERNO_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            List<ProviderGoodsStockVo> list = localStoreOrderVo.getList();
            for (ProviderGoodsStockVo p : list) {
                int temp = providerProductFashionRepos.updateCountBySkuAndSotreId(p.getSku(), localStoreOrderVo.getStoreId(), p.getStockCount());
                if (temp <= 0) {
                    throw new RuntimeException("更新SKU:" + p.getSku() + "失败");
                }
            }
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
            return baseResponse;
        }
        baseResponse.setResultCode(MessageDictionary.OREDE_REQUEST_REPEAT);
        baseResponse.setResultMessage("订单重复提交");
        return baseResponse;
    }

    @Override
//    @Transactional(rollbackFor = Exception.class)
    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        BaseResponse baseResponse = new BaseResponse();
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("LocalCancelOccupyStock:OrderNo" + thrOrderNo + '9');
        if (boundValueOperations.setIfAbsent(true)) {
            boundValueOperations.expire(1, TimeUnit.MILLISECONDS);
            if (Lang.isEmpty(thrOrderNo) && Lang.isEmpty(storedId)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_ORDERNO_ERROR_MESSAGE, "", MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            OrderMainDto order = orderMainApi.findOrderByThirdOrderNoAndProviderId(thrOrderNo, storedId);
            List<ProviderGoodsStockVo> list = new ArrayList<>();
            if (!Lang.isEmpty(order)) {
                List<OrderItemDto> orderItems = order.getOrderItems();
                for (OrderItemDto orderItem : orderItems) {
                    ProviderGoodsStockVo providerGoodsStockVo = new ProviderGoodsStockVo();
                    providerGoodsStockVo.setSku(orderItem.getSku());
                    providerGoodsStockVo.setStockCount(orderItem.getCount());
                    list.add(providerGoodsStockVo);
                }
            } else {
                return new BaseResponse("订单信息查询失败");
            }
            for (ProviderGoodsStockVo p : list) {
                int temp = providerProductFashionRepos.updateAddCountBySkuAndSotreId(p.getSku(), storedId, p.getStockCount());
                if (temp <= 0) {
                    throw new RuntimeException("");
                }
            }
        }
        baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
        return baseResponse;
    }

    public Map<String, Object> findGoodsUpperAndLowersSql(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        Map<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String orgCodeStr = "";
        //合作伙伴
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getOrgCode()) && !"all".equals(goodsUpperAndLowerQueryDto.getOrgCode().trim())) {
            orgCodeStr = " and gc.organization_code = :orgcode ";
            params.put("orgcode", goodsUpperAndLowerQueryDto.getOrgCode().trim());
        }
        sql.append(" select g.* from ")
                .append("    (")
                .append("        SELECT")
                .append("            ppf.category_name AS categoryname,")
                .append("            ppf.provider_name AS providername,")
                .append("            ppf.sku AS sku,")
                .append("            ppf.name AS name,")
                .append("            ppf.brand_name AS brandname,")
                .append("            ppf.market_price AS originalPrice,")
                .append("            ppf.cost_price AS costprice,")
                .append("            gcc.price AS saleprice,")
                .append("            ppf.agreement_discount_rate AS agreementdiscountrate,")
                .append("            ppf.real_time_discount_rate AS realtimediscountrate,")
                .append("            ppf.rate_mode_rate AS ratemoderate,")
                .append("            gcc.is_up AS isup,")
                .append("            gcc.is_preferred AS ispreferred,")
                .append("            ppf.store_id AS storeid,")
                .append("            ppf.category_id as categoryid,")
                .append("            ppf.brand_id as brandid,")
                .append("            gcc.organization_code AS organizationcode ")
                .append("        FROM")
                .append("            provider_product_fashion ppf,")
                .append("           ( select gc.price, gc.is_up, gc.is_preferred, gc.sku, gc.user_id, gc.organization_code ")
                .append("            from  goods_config gc where  gc.is_delete = 0 ")
                .append(orgCodeStr)
                .append("            ) gcc")
                .append("        WHERE")
                .append("                ppf.sku = gcc.sku (+)")
                .append("            AND")
                .append("                ppf.store_id = gcc.user_id (+)")
                .append("            AND")
                .append("                ppf.provider_sale_status = '1'")
                .append("            AND")
                .append("                ppf.is_delete = 0")
                .append("    ) g ")
                .append(" WHERE 1=1 ");

        //上下架状态
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getIsUp()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsUp().trim())) {
            if (ISUP_NOT_SHELF.equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup or g.isup is null)");
            }
            if (ISUP_ALREADY_SHELF.equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup )");
            }
            params.put("isup", goodsUpperAndLowerQueryDto.getIsUp());
        }
        //是否优选
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getIsPreferred()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsPreferred().trim())) {
            if (PREFERENCE_NO.equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and (g.ispreferred = :ispreferred or g.ispreferred is null)");
            }
            if (PREFERENCE_YES.equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and g.ispreferred = :ispreferred ");
            }
            params.put("ispreferred", goodsUpperAndLowerQueryDto.getIsPreferred());
        }
        //销售价
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice <= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :startsaleprice  and g.saleprice <= :endsaleprice ");
            params.put("startsaleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
            params.put("endsaleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        }
        //分类

        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getProductCategoryId())) {
            List<String> threeCategoryId = productCategoryApi.findThreeCategoryByCategoryId(goodsUpperAndLowerQueryDto.getProductCategoryId());
            sql.append(" and g.categoryid  in (:categoryid) ");
            params.put("categoryid", threeCategoryId);
        }
        //供应商SKU
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getSku())) {
            sql.append(" and g.sku = :sku ");
            params.put("sku", goodsUpperAndLowerQueryDto.getSku());
        }
        //供应商
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStoreId()) && !"all".equals(goodsUpperAndLowerQueryDto.getStoreId().trim())) {
            sql.append(" and g.storeid = :storeid ");
            params.put("storeid", goodsUpperAndLowerQueryDto.getStoreId());
        }
        //商品名称
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getName())) {
            sql.append(" and g.name like (:name) ");
            params.put("name", "%" + goodsUpperAndLowerQueryDto.getName() + "%");
        }
        //品牌
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getBrandIds())) {
            List<Object> list = new ArrayList<Object>();
            String[] brandArry = goodsUpperAndLowerQueryDto.getBrandIds().split(",");
            for (String brand : brandArry) {
                list.add(brand);
            }
            sql.append(" and g.brandid in (:brandid) ");
            params.put("brandid", list);
        }
        //协议价
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice <= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :startcostprice  and g.costprice <= :endcostprice ");
            params.put("startcostprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
            params.put("endcostprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        }
        //费率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate <= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :startratemoderate  and g.ratemoderate <= :endratemoderate ");
            params.put("startratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
            params.put("endratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        }
        //协议折扣率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate <= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :startagreementdiscountrate  and g.agreementdiscountrate <= :endagreementdiscountrate ");
            params.put("startagreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
            params.put("endagreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        }
        //实时折扣率
        if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
        } else if (Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate <= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        } else if (!Lang.isEmpty(goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty(goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :startrealtimediscountrate  and  g.realtimediscountrate <= :endrealtimediscountrate ");
            params.put("startrealtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
            params.put("endrealtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        }
        log.info("商品上下架页面列表查询sql===》：{}", sql.toString());
        Map<String, Object> map = new HashedMap();
        map.put("sql", sql.toString());
        map.put("params", params);
        return map;
    }

    @Override
    public BaseResponse<List<GoodsUpperAndLowerDto>> findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        List<GoodsUpperAndLowerDto> goodsUpperAndLowerDtos = null;
        Map<String, Object> sqlListMap = findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            goodsUpperAndLowerDtos = namedParameterJdbcTemplate.query(String.valueOf(sqlListMap.get("sql")), (Map<String, Object>) sqlListMap.get("params"), new BeanPropertyRowMapper<GoodsUpperAndLowerDto>(GoodsUpperAndLowerDto.class));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("商品列表查询失败 {}", e);
            return new BaseResponse<>(false, "商品列表查询失败", goodsUpperAndLowerDtos);
        }
        return new BaseResponse<>(true, "商品列表查询成功", goodsUpperAndLowerDtos);
    }

    /**
     * 删除商品
     *
     * @param skus
     * @param storeId
     * @return
     */
    @Override
    public BaseResponse deleteProviderGoodsBatch(List<String> skus, String storeId) {

        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty(skus)) {
                return new BaseResponse(false, MessageDictionary.RETURN_NULL_PARAM_SKU_ERROR_MESSAGE, "",
                        MessageDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
            }
            providerProductFashionRepos.deleteProviderGoodsBatch(skus, NOT_ON_SALE, true, storeId, new Date());

            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
        } catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, MessageDictionary.RETURN_INTERNAL_ERROR_MESSAGE, "",
                    MessageDictionary.RETURN_INTERNAL_EXCEPTION_CODE);
        }

        if (baseResponse.isSuccess()) {
            //删除成功后向销售服务推送消息
            StoreDto storeDto = storeService.getStoreByStoreId(storeId);
            mqHandleProducer.sendProductDeleteMessage(skus, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }

    @Override
    @Transactional
    public ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        List<ProviderGoodsDto> providerGoodsDtos = new ArrayList<>();
        ProviderGoodsDto providerGoodsDto = null;
        try {
            if (Lang.isEmpty(sku)) {
                return providerGoodsDto;
            }
            if (Lang.isEmpty(storeId)) {
                return providerGoodsDto;
            }
            ProviderProductFashion providerProductFashion = providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            providerGoodsDto = mapperFacade.map(providerProductFashion, ProviderGoodsDto.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return providerGoodsDto;
    }

    @Override
    @Transactional
    public List<ProviderGoodsDto> queryProviderGoodsDtoList(String modelSku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        List<ProviderGoodsDto> goodsDtoList = null;
        try {
            if (Lang.isEmpty(modelSku)) {
                return null;
            }
            if (Lang.isEmpty(storeId)) {
                return null;
            }
            List<ProviderProductFashion> providerProductFashionList = providerProductFashionRepos.findByModelSkuAndStoreId(modelSku, storeId);
            goodsDtoList = mapperFacade.mapAsList(providerProductFashionList, ProviderGoodsDto.class);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return goodsDtoList;
    }

    ExecutorService preferExecutorService = new ThreadPoolExecutor(10, 15, 1, TimeUnit.MINUTES, new LinkedBlockingDeque<>(20000));

    @Override
    @Transactional
    public BaseResponse<List<String>> preferredOrIsUpByThread(GoodsUpperAndLowerVo goodsUpperAndLowerVo) {

        String organizationCode = goodsUpperAndLowerVo.getGoodsUpperAndLowerQueryDto().getOrgCode();

        int pageSize = 10;
        int page = 0;
        int size = goodsUpperAndLowerVo.getGoodsUpperLowerDtos().size();
        if (size > 5000) {
            pageSize = size / 200;
        } else if (size > 2000) {
            pageSize = size / 100;
        } else if (size > 1000) {
            pageSize = size / 50;
        } else if (size < 10) {
            pageSize = 2;
        }

        //分批数
        int totalPage = size / pageSize;
        if (size % pageSize > 0) {
            totalPage++;
        }
        List<Future<List<String>>> futures = new ArrayList<>();
        for (; page < totalPage; page++) {
            int startIndex = pageSize * page;
            int endIndexTemp = pageSize * (page + 1);
            if (endIndexTemp > size) {
                endIndexTemp = size;
            }
            int endIndex = endIndexTemp;
            try {
                log.info(" skuIndex === {} === {} ", startIndex, endIndex);
                Future<List<String>> future = preferExecutorService.submit(() -> {
                    Boolean isPreferred = null;
                    Boolean isUp = null;
                    if (goodsUpperAndLowerVo.getOpertionCode().equals(ISPREFERRED)) {
                        isPreferred = true;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(DISPREFERRED)) {
                        isPreferred = false;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(ISUP)) {
                        isUp = true;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(DISUP)) {
                        isUp = false;
                    } else {
                        throw new RuntimeException("没有要执行的操作");
                    }
                    if (isPreferred != null) {
                        BaseResponse<List<String>> preferredaseResponse = preferenceAndUpperShelvesImpl.preferredImpl(goodsUpperAndLowerVo.getGoodsUpperLowerDtos().subList(startIndex, endIndex), isPreferred, organizationCode);
                        if (!Lang.isEmpty(preferredaseResponse.getResult())) {
                            return preferredaseResponse.getResult();
                        }
                    } else if (isUp != null) {
                        BaseResponse<List<String>> isUpResponse = preferenceAndUpperShelvesImpl.goodsUpOrNot(goodsUpperAndLowerVo.getGoodsUpperLowerDtos().subList(startIndex, endIndex), isUp, organizationCode);
                        if (!Lang.isEmpty(isUpResponse.getResult())) {
                            return isUpResponse.getResult();
                        }
                    }
                    return null;
                });
                futures.add(future);
            } catch (Exception e) {
                log.error("多线程处理商品异常", e);
            }
        }
        List<String> result = new ArrayList<>();
        for (int t = 0; t < futures.size(); t++) {
            try {
                List<String> list = futures.get(t).get();
                if (!Lang.isEmpty(list)) {
                    result.addAll(list);
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (size == result.size()) {
            if (size == 1) {
                return new BaseResponse(false, "失败", result, ONE);
            }
            return new BaseResponse(false, "全部失败", result, ZERO);
        } else if (!Lang.isEmpty(result)) {
            if (size == 1) {
                return new BaseResponse(true, "操作结束", result, ONE);
            }
            return new BaseResponse(true, "操作结束", result, ZERO);
        } else {
            if (size == 1) {
                return new BaseResponse(true, "没有返回失败的SKU,全部成功", "", ONE);
            }
            return new BaseResponse(true, "没有返回失败的SKU,全部成功", "", ZERO);
        }
    }

    @Override
    @Transactional
    public List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, Boolean isDelete) {
        List<ProviderProductFashion> providerProductFashionList = providerProductFashionRepos.findAll(new Specification<ProviderProductFashion>() {
            @Override
            public Predicate toPredicate(Root<ProviderProductFashion> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicateList = new ArrayList<>();
                predicateList.add(criteriaBuilder.equal(root.get("modelSku"), modelSku));
                predicateList.add(criteriaBuilder.equal(root.get("storeId"), storeId));
                predicateList.add(criteriaBuilder.equal(root.get("isDelete"), isDelete));
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            }
        });
        List<ProviderGoodsDto> providerGoodsDtoList = mapperFacade.mapAsList(providerProductFashionList, ProviderGoodsDto.class);
        return providerGoodsDtoList;
    }

    @Override
    public void updateBrandInfo(String id, String brandName, String brandId) {
        providerProductFashionRepos.updateBrandInfo(id, brandName, brandId);
    }

    //
    public BaseResponse saveProviderProduct(ProductModelDto productModel, List<ProviderGoodsDto> providerGoodsDtos) {
        log.info("第三方供应商对接接口，保存商品接口输入参数：{}", JSON.toJSONString(providerGoodsDtos, SerializerFeature.WriteMapNullValue));
        BaseResponse baseResponse = new BaseResponse();

        BaseResponse<ProductModelDto> productModelDtoResponse = null;
        String modelSku = productModel.getModelSku();
        Boolean saveModelFlag = true;
        try {
            if (Lang.isEmpty(productModel.getModelSku())) {
                modelSku = sequenceUtil.getOrderNo("sku");
                productModel.setModelSku(modelSku);
                productModel.setModelId(null);
                productModelDtoResponse = productModelService.saveModel(productModel);
                saveModelFlag = productModelDtoResponse.isSuccess() && MessageDictionary.RETURN_SUCCESS_CODE.equals(productModelDtoResponse.getResultCode());
                if (!saveModelFlag) {
                    return productModelDtoResponse;
                }
            }

            if (saveModelFlag) {
                for (ProviderGoodsDto providerGoods : providerGoodsDtos) {
                    providerGoods.setModelSku(modelSku);
                    if (Lang.isEmpty(providerGoods.getSku())) {
                        String sku = sequenceUtil.getOrderNo("sku");
                        providerGoods.setSku(sku);
                        providerGoods.setStatus(String.valueOf(ProviderProductFashionStatusEnum.up.getCode()));
                    }
                    providerGoods.setBrandId(productModel.getBrandId());
                    providerGoods.setStatus(String.valueOf(ProviderProductFashionStatusEnum.dwon.getCode()));
                    providerGoods.setStoreId(productModel.getStoreId());
                }
            }
        } catch (InterruptedException e) {
            log.error("添加产品时报错,storeId:{}：", productModel.getStoreId());
            throw new RuntimeException(e);
        }

        for (ProviderGoodsDto providerGoodsDto : providerGoodsDtos) {
            BaseResponse simple = this.saveProviderGoods(providerGoodsDto);
            if (!MessageDictionary.RETURN_SUCCESS_CODE.equals(simple.getResultCode()) || !simple.isSuccess()) {
                throw new RuntimeException("批量保存商品错误，商品" + providerGoodsDto.getSku() + ",错误信息：" + simple.getResultMessage());
            }
        }

        baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
        baseResponse.setResult("");
        return baseResponse;
    }


    @Override
    @Transactional
    public BaseResponse<List<ProviderGoodsDto>> updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponse<ProductModelDto> productModelDtoResponse = productModelService.updateModel(updateProviderGoodsVo.getProductModel());
        try {
            if (productModelDtoResponse.isSuccess() && MessageDictionary.RETURN_SUCCESS_CODE.equals(productModelDtoResponse.getResultCode())) {
                List<ProviderGoodsDto> addGoodsList = new ArrayList();
                List<ProviderGoodsDto> updateGoodsList = new ArrayList();
                for (ProviderGoodsDto goods : updateProviderGoodsVo.getUpdate()) {
                    goods.setModelSku(updateProviderGoodsVo.getProductModel().getModelSku());
                    goods.setStoreId(updateProviderGoodsVo.getProductModel().getStoreId());
                    if (Lang.isEmpty(goods.getSku())) {
                        String sku = sequenceUtil.getOrderNo("sku");
                        goods.setSku(sku);
                        addGoodsList.add(goods);
                    } else {
                        updateGoodsList.add(goods);
                    }
                }

                if (!Lang.isEmpty(addGoodsList)) {
                    BaseResponse saveResponse = this.saveProviderProduct(updateProviderGoodsVo.getProductModel(), addGoodsList);
                    if (!MessageDictionary.RETURN_SUCCESS_CODE.equals(saveResponse.getResultCode()) || !saveResponse.isSuccess()) {
                        throw new RuntimeException("更新商品添加时发生错误，错误信息： " + saveResponse.getResultMessage());
                    }
                }
                for (ProviderGoodsDto providerGoodsDto : updateGoodsList) {
                    BaseResponse simple = this.updateProviderGoods(providerGoodsDto);
                    if (!MessageDictionary.RETURN_SUCCESS_CODE.equals(simple.getResultCode()) || !simple.isSuccess()) {
                        throw new RuntimeException("更新商品错误，商品" + providerGoodsDto.getSku() + ",错误信息：" + simple.getResultMessage());
                    }
                }
                if (!Lang.isEmpty(updateProviderGoodsVo.getDel())) {
                    BaseResponse saveResponse = this.deleteProviderGoodsBatch(updateProviderGoodsVo.getDel(), updateProviderGoodsVo.getStoreId());
                    if (!MessageDictionary.RETURN_SUCCESS_CODE.equals(saveResponse.getResultCode()) || !saveResponse.isSuccess()) {
                        throw new RuntimeException("更新商品删除时发生错误，错误信息： " + saveResponse.getResultMessage());
                    }
                }
                baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
                baseResponse.setSuccess(true);
                baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
                baseResponse.setResult("");
                return baseResponse;
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        baseResponse.setResultCode(productModelDtoResponse.getResultCode());
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage(productModelDtoResponse.getResultMessage());
        baseResponse.setResult(null);
        return baseResponse;

    }

}
