package pool.service.service.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.dto.ProviderProductFashionDto;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.ProviderProductFashionService;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.List;

/**
 * taofeng
 */
@Slf4j
@Service
public class ProviderProductFashionServiceImpl implements ProviderProductFashionService {

    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;

    @Override
    @Transactional
    public ProviderProductFashionDto findBySkuAndStoreId(String sku, String storeId, boolean isDelete) {
        List<ProviderProductFashion> providerProductFashions = providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(sku, storeId, false);
        if (Lang.isEmpty(providerProductFashions)) {
            return null;
        }
        long providerProductFashionDtoTime = System.currentTimeMillis();
        ProviderProductFashionDto providerProductFashionDto = BeanMapper.map(providerProductFashions.get(0), ProviderProductFashionDto.class);
        log.info("providerProductFashionDto拷贝时间 {} ms", System.currentTimeMillis() - providerProductFashionDtoTime);
        return providerProductFashionDto;
    }

}
