package pool.service.service.ServiceImpl.providerproductfashion;

import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.dto.PicDto;
import pool.model.ProviderProductFashionPicture;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductFashionRepos;

import java.util.List;

@Service
public class ProviderProductFashionUpdateServiceImpl implements ProviderProductFashionUpdateService {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private MapperFacade mapperFacade;

    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;
    @Transactional
    public List<PicDto> findPicturesByFashionId(String id){
        ProviderProductFashion productGoods = providerProductFashionRepos.findOne(id);
        List<ProviderProductFashionPicture> providerProductFashionPictureList = productGoods.getPics();
        List<PicDto> picDtoList = mapperFacade.mapAsList(providerProductFashionPictureList,PicDto.class);
        return picDtoList;
    }
}
