package pool.service.service;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;

import java.util.concurrent.TimeUnit;

/**
 * Created by Jian on 2018-8-29.
 */
@Slf4j
@Service
public class StoreService {

    private static String storeCacheKey = "STORE_CACHE";

    private static String storeIdCacheKey = "STORE_ID_CACHE";

    @Autowired
    RedisTemplate redisTemplate;

    @MotanReferer
    StoreApi storeApi;

    /**
     * 查询店铺信息
     * @param storeCode
     * @return
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public StoreDto getStoreByCode(String storeCode) {
        BoundValueOperations storeCacheOperations = redisTemplate.boundValueOps(storeCacheKey + ":code:" + storeCode);
        if (storeCacheOperations.get() != null) {
            return JSON.parseObject((String) storeCacheOperations.get(), StoreDto.class);
        }
        StoreDto storeDto = storeApi.findByCode(storeCode);
        storeCacheOperations.set(JSON.toJSONString(storeDto), 1, TimeUnit.HOURS);
        return storeDto;
    }


    /**
     * 查询店铺信息
     * @param storeId
     * @return
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public StoreDto getStoreByStoreId(String storeId) {
        BoundValueOperations storeCacheOperations = redisTemplate.boundValueOps(storeIdCacheKey + ":storeId:" + storeId);
        if (storeCacheOperations.get() != null) {
            return JSON.parseObject((String) storeCacheOperations.get(), StoreDto.class);
        }
        StoreDto storeDto = storeApi.findByStoreId(storeId);
        if(storeDto!=null) {
            storeCacheOperations.set(JSON.toJSONString(storeDto), 1, TimeUnit.HOURS);
        }
        return storeDto;
    }
}
