package pool.service.service.initproduct.jd;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.product.CategoryEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.request.product.SkuEntity;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pool.dto.BrandDto;
import pool.dto.ProviderCategoryDto;
import pool.model.*;
import pool.model.repository.ProviderProductBrandRepos;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.model.repository.ProviderProductRepos;
import pool.service.service.BrandService;
import pool.service.service.ProviderGoodsService;
import pool.service.service.StoreService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.collection.CollectionUtil;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.*;

/**
 * Created by Jian on 2018-9-11.
 */
@RestController
public class ProductInitBatchService {

    Logger logger = LoggerFactory.getLogger(getClass());
    ExecutorService productExecutorService = new ThreadPoolExecutor(30, 30, 5, TimeUnit.MINUTES, new LinkedBlockingDeque<>(200000));

    @MotanReferer
    JdProductApi jdProductApi;

    @Autowired
    ProviderGoodsService providerGoodsService;

    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;

    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;

    @Autowired
    ProviderProductRepos providerProductRepos;

    @Autowired
    private BrandService brandService;
    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;

    @Autowired
    StoreService storeService;

    @RequestMapping("productInit2")
    public Object init() {
        String storeCode = "jd";
//        StoreDto storeDto = storeService.getStoreByCode(storeCode);
        String storeId ="8ce42ec1-8c83-4f22-80c6-e31cdc0dab14";
        List<ProductPoolVO> productPools = jdProductApi.getProductPool();
        List<Future> futures = new ArrayList<>();
        productPools.forEach(productPoolVO -> {
            String page_num = productPoolVO.getPage_num();
            List<Long> skusPool = jdProductApi.getProductPoolProduct(new PageNumEntity(page_num));
            List<List<Long>> pageList = CollectionUtil.getPageList(skusPool, 90);

            pageList.forEach(skus -> {
                Future<Object> future = productExecutorService.submit(new Callable<Object>() {
                    @Override
                    public Object call() throws Exception {
                        try {
                            long millis = System.currentTimeMillis();
                            Map<Long,ProviderProductFashion> skuDetails=new HashMap();
                            List<ProviderProduct> providerProducts= new ArrayList<ProviderProduct>();
                            List<String> skuList= new ArrayList<>();
                            skus.forEach(sku -> {

                                ProviderProductFashion goods = new ProviderProductFashion();
                                goods.setSku(sku.toString());
                                goods.setStoreId(storeId);
                                goods.setIsDelete(false);
                                boolean goodsExist = providerProductFashionRepos.exists(Example.of(goods));
                                if(!goodsExist) {

                                    ProductDetailVO productDetail = jdProductApi.getProductDetail(new ProductDetailEntity(sku));
                                    if(!Lang.isEmpty(productDetail)) {
                                        ProviderProductFashion goodsDto = new ProviderProductFashion();
                                        goodsDto.setSku(String.valueOf(sku));
                                        goodsDto.setCostPrice(new BigDecimal(0));
                                        goodsDto.setMarketPrice(new BigDecimal(0));
                                        goodsDto.setWeight(productDetail.getWeight());
                                        goodsDto.setWareQD(productDetail.getWareQD());
                                        goodsDto.setName(productDetail.getName());
                                        goodsDto.setParam(productDetail.getParam());
                                        goodsDto.setSaleUnit(productDetail.getSaleUnit());
                                        goodsDto.setUpc(productDetail.getUpc());
                                        goodsDto.setProductArea(productDetail.getProductArea());
                                        goodsDto.setIntroduction(productDetail.getIntroduction());
                                        goodsDto.setProviderSaleStatus(productDetail.getState());
                                        //发票类型 1：增票、普票 2：增票 3：普票 4：都不支持
                                        goodsDto.setInvoiceType(1);
                                        goodsDto.setBrandName(productDetail.getBrandName());
                                        goodsDto.setStoreId(storeId);
                                        goodsDto.setProvideName("京东旗舰店");

                                        ProviderProduct providerProduct = new ProviderProduct();
                                        providerProduct.setStoreId(storeId);
                                        providerProduct.setModelSku(String.valueOf(productDetail.getSku()));
                                        providerProduct.setName(productDetail.getName());
                                        goodsDto.setModelSku(String.valueOf(sku));
                                        String categoryName ="";
                                        logger.info("sku:{},categorycode:{}",sku,productDetail.getCategory());
                                        if(!Lang.isEmpty(productDetail.getCategory())) {
                                            String[] categoryList = productDetail.getCategory().split(";");

                                            ProviderCategoryDto pcd = new ProviderCategoryDto();
                                            CategoryResp resp;
                                            if(!Lang.isEmpty(categoryList[0])) {
                                                resp = jdProductApi.getCategory(new CategoryEntity(categoryList[0]));
                                                if(!Lang.isEmpty(resp) && !Lang.isEmpty(resp.getResult())){
                                                    pcd.setFstLevelCode(categoryList[0]);
                                                    pcd.setFstLevelName(resp.getResult().getName());
                                                }
                                            }

                                            if(!Lang.isEmpty(categoryList[1])) {
                                                resp = jdProductApi.getCategory(new CategoryEntity(categoryList[1]));
                                                if(!Lang.isEmpty(resp) && !Lang.isEmpty(resp.getResult())){
                                                    pcd.setSecLevelCode(categoryList[1]);
                                                    pcd.setSecLevelName(resp.getResult().getName());
                                                }

                                            }
                                            if(!Lang.isEmpty(categoryList[2])) {
                                                resp = jdProductApi.getCategory(new CategoryEntity(categoryList[2]));
                                                if(!Lang.isEmpty(resp) && !Lang.isEmpty(resp.getResult())){
                                                    pcd.setThdLevelCode(categoryList[2]);
                                                    pcd.setThdLevelName(resp.getResult().getName());
                                                }

                                            }

//
                                            ProviderProductCategory providerProductCategoryThree = null;
                                            ProviderProductCategory providerProductCategoryTwo = null;
                                            ProviderProductCategory providerProductCategoryOne = null;

                                            //查询三级分类
                                            if (!Lang.isEmpty(pcd.getThdLevelCode())) {
                                                providerProductCategoryThree = providerProductCategoryRepos.findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getThdLevelCode(), 3, storeId, false);
                                            }
                                            if (!Lang.isEmpty(providerProductCategoryThree)) {
                                                providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
                                                providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());
                                            } else {
                                                //查询二级分类
                                                if (!Lang.isEmpty(pcd.getSecLevelCode())) {
                                                    providerProductCategoryTwo = providerProductCategoryRepos
                                                            .findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getSecLevelCode(), 2, storeId, false);
                                                }
                                                if (!Lang.isEmpty(providerProductCategoryTwo)) {
                                                    if(!Lang.isEmpty(pcd.getThdLevelName()) && !Lang.isEmpty(pcd.getThdLevelCode())){
                                                        providerProductCategoryThree = new ProviderProductCategory();
                                                        providerProductCategoryThree.setStoreId(storeId);
                                                        providerProductCategoryThree.setName(pcd.getThdLevelName());
                                                        providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                                                        providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                                                        providerProductCategoryThree.setLayerIndex(3);
                                                        providerProductCategoryThree.setParent(providerProductCategoryTwo);
                                                        providerProductCategoryRepos.save(providerProductCategoryThree);

                                                    }
                                                } else {
                                                    //查询一级分类
                                                    if (!Lang.isEmpty(pcd.getFstLevelCode())) {
                                                        providerProductCategoryOne = providerProductCategoryRepos
                                                                .findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getFstLevelCode(), 1, storeId, false);
                                                    }
                                                    if (!Lang.isEmpty(providerProductCategoryOne)) {
                                                        if(!Lang.isEmpty(pcd.getSecLevelCode()) && !Lang.isEmpty(pcd.getSecLevelName())){

                                                            providerProductCategoryTwo = new ProviderProductCategory();
                                                            providerProductCategoryTwo.setStoreId(storeId);
                                                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                                                            providerProductCategoryTwo.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getSecLevelName());
                                                            providerProductCategoryTwo.setLayerIndex(2);
                                                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                                                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                                                            providerProductCategoryTwo = providerProductCategoryRepos.save(providerProductCategoryTwo);
                                                        }

                                                        if(!Lang.isEmpty(pcd.getThdLevelCode()) && !Lang.isEmpty(pcd.getThdLevelName())) {

                                                            providerProductCategoryThree = new ProviderProductCategory();
                                                            providerProductCategoryThree.setStoreId(storeId);
                                                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                                                            providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                                                            providerProductCategoryThree.setLayerIndex(3);
                                                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                                                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                                                            providerProductCategoryRepos.save(providerProductCategoryThree);
                                                        }
                                                    } else {
                                                        if(!Lang.isEmpty(pcd.getFstLevelCode()) && ! Lang.isEmpty(pcd.getFstLevelName())) {

                                                            providerProductCategoryOne = new ProviderProductCategory();
                                                            providerProductCategoryOne.setStoreId(storeId);
                                                            providerProductCategoryOne.setName(pcd.getFstLevelName());
                                                            providerProductCategoryOne.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getFstLevelName());
                                                            providerProductCategoryOne.setLayerIndex(1);
                                                            providerProductCategoryOne.setCode(pcd.getFstLevelCode());
                                                            providerProductCategoryOne = providerProductCategoryRepos.save(providerProductCategoryOne);
                                                        }

                                                        if(!Lang.isEmpty(pcd.getSecLevelCode()) && !Lang.isEmpty(pcd.getSecLevelName())){

                                                            providerProductCategoryTwo = new ProviderProductCategory();
                                                            providerProductCategoryTwo.setStoreId(storeId);
                                                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                                                            providerProductCategoryTwo.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getSecLevelName());
                                                            providerProductCategoryTwo.setLayerIndex(2);
                                                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                                                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                                                            providerProductCategoryTwo = providerProductCategoryRepos.save(providerProductCategoryTwo);
                                                        }

                                                        if(!Lang.isEmpty(pcd.getThdLevelCode()) && !Lang.isEmpty(pcd.getThdLevelName())) {

                                                            providerProductCategoryThree = new ProviderProductCategory();
                                                            providerProductCategoryThree.setStoreId(storeId);
                                                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                                                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                                                            providerProductCategoryThree.setCategoryRemarks("供应商推送商品消息分类：" + pcd.getThdLevelName());
                                                            providerProductCategoryThree.setLayerIndex(3);
                                                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                                                            providerProductCategoryRepos.save(providerProductCategoryThree);
                                                        }
                                                    }

                                                }

                                            }
                                            providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
                                            providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());

                                        }
                                        ProviderProductBrand brand =null;
                                        if (!Lang.isEmpty(productDetail.getBrandName())) {

                                            List<ProviderProductBrand> providerProductBrands = providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(productDetail.getBrandName(),storeId, false);
                                            if (!Lang.isEmpty(providerProductBrands)) {
                                                brand = providerProductBrands.get(0);
                                                providerProduct.setProductBrandId(brand.getProductBrandId());
                                                providerProduct.setBrandId(brand.getId());
                                            } else {
                                                //创建品牌
                                                BrandDto brandDto = new BrandDto();
                                                brandDto.setName(productDetail.getBrandName());
                                                brandDto.setStoreId(storeId);
                                                brandDto.setSimpleName(productDetail.getBrandName());
                                                // TODO: 2018-9-5 返回类型修改为vo
                                                BaseResponse<Map<String, String>> response = brandService.saveBrand(brandDto);
                                                if (response.isSuccess()) {
                                                    Map<String, String> map = response.getResult();
                                                    brand = providerProductBrandRepos.findOne(map.get("brandId"));
                                                    providerProduct.setProductBrandId(brand.getProductBrandId());
                                                    providerProduct.setBrandId(brand.getId());
                                                }
                                            }
                                        }

                                        providerProducts.add(providerProduct);
                                        goodsDto.setProviderProduct(providerProduct);
                                        if(!Lang.isEmpty(providerProduct.getCategoryId())) {
                                            goodsDto.setCategoryId(providerProduct.getCategoryId());
//                                        ProductCategoryVo pcv = productCategoryApi.findByIdAndIsDelete(providerProduct.getCategoryId());
//                                        if(pcv !=null){
//                                            providerProductFashion.setCategoryName(pcv.getParentName()+"/"+pcv.getName());
//                                        }
                                        }
                                        if(!Lang.isEmpty(brand)) {
                                            goodsDto.setBrandName(brand.getProductBrandName());
                                            goodsDto.setBrandId(brand.getProductBrandId());
                                        }
                                        skuDetails.put(sku,goodsDto);
                                        skuList.add(String.valueOf(sku));
                                    }
                                }

                            });

//                            skus.forEach(sku -> {
//
//                            });


                            //获取商品价格信息
                            List<PriceVO> prices = jdProductApi.getPrice(new SkuEntity(String.join(",",skuList)));
                            if (prices == null || prices.size() == 0) {

                            }else {
                                PriceVO priceVO = prices.get(0);
                                logger.info("==========pricesvo:{}",priceVO.toString());
                                prices.forEach(priceVO1 -> {

                                    ProviderProductFashion ppf = skuDetails.get(priceVO1.getSkuId());
                                    ppf.setCostPrice(Lang.isEmpty(priceVO1.getPrice()) ? new BigDecimal(0):priceVO1.getPrice());
                                    ppf.setMarketPrice(Lang.isEmpty(priceVO1.getJdPrice()) ? new BigDecimal(0):priceVO1.getJdPrice());
                                    skuDetails.put(priceVO1.getSkuId(),ppf);
                                });

//                                goodsDto.setCostPrice(priceVO.getPrice());
//                                goodsDto.setMarketPrice(priceVO.getJdPrice());
                            }

                            Map<Long, List<ProductSkuImageVO>> imageMap = jdProductApi.getProductSkuImage(skus);

                            for (Map.Entry<Long, List<ProductSkuImageVO>> entry : imageMap.entrySet()) {
                                //Map.entry<Integer,String> 映射项（键-值对）  有几
//                                System.out.println("sku= " + entry.getKey() + " image= "+ entry.getValue());
                                if(!Lang.isEmpty(entry.getKey())){
                                    ProviderProductFashion ppf2 = skuDetails.get(entry.getKey());
                                    List<ProductSkuImageVO> productSkuImageVOs = imageMap.get(entry.getKey());
                                    if (productSkuImageVOs == null || productSkuImageVOs.size() == 0) {
                                        throw new RuntimeException("productSkuImageVOs：商品图片信息为空,商品编号:" + entry.getKey());
                                    }
                                    List<ProviderProductFashionPicture> pics = new ArrayList<>();
                                    for (ProductSkuImageVO productSkuImageVO:productSkuImageVOs) {
                                        ProviderProductFashionPicture pic = new ProviderProductFashionPicture();
                                        pic.setPath("http://img20.360buyimg.com/vc/"+productSkuImageVO.getPath());
                                        pic.setFeatures(productSkuImageVO.getFeatures());
                                        pic.setIsPrimary(productSkuImageVO.getIsPrimary()==0?false:true);
                                        if(!Lang.isEmpty(productSkuImageVO.getOrderSort())) {
                                            pic.setOrderSort(Integer.valueOf(productSkuImageVO.getOrderSort()));
                                        }
                                        pic.setPosition(productSkuImageVO.getPosition());
                                        pic.setType(String.valueOf(productSkuImageVO.getType()));
                                        pic.setProviderProductFashion(ppf2);
                                        pics.add(pic);
                                    }
                                    ppf2.setPics(pics);
                                    skuDetails.put(entry.getKey(),ppf2);
                                }
                            }

                            //商品的可售性校验
                            ProductCheckResp productCheckResp = jdProductApi.getSkuCheck(skus);
                            if (!Lang.isEmpty(productCheckResp) && !Lang.isEmpty(productCheckResp.getResult())) {
                                for (ProductCheckRepVO productCheckRepVO : productCheckResp.getResult()) {
                                    ProviderProductFashion ppf3 = skuDetails.get(productCheckRepVO.getSkuId());
                                    ppf3.setProviderSaleStatus(1);
                                    ppf3.setPostSalePolicy(1);
                                    //商品不可售或者不支持开增票，需要将商品不上架处理
                                    if (productCheckRepVO.getIsCanVAT() == ProductCheckRepVO.CAN_VAT_NO_SUPPORT ||
                                            productCheckRepVO.getSaleState() == ProductCheckRepVO.SALE_NO_SUPPORT) {
                                        ppf3.setProviderSaleStatus(0);
                                    }
                                    if(0==productCheckRepVO.getIs7ToReturn()){
                                        ppf3.setPostSalePolicy(1);
                                    }
                                    skuDetails.put(productCheckRepVO.getSkuId(),ppf3);
                                }
                            }


                            Collection<ProviderProductFashion> valueCollection = skuDetails.values();
                            List<ProviderProductFashion> skuDetailList = new ArrayList<ProviderProductFashion>(valueCollection);

                            providerProductRepos.save(providerProducts);
                            providerProductFashionRepos.save(skuDetailList);
                            logger.info("同步商品保存时间：{}", System.currentTimeMillis() - millis);

                        } catch (Exception e) {
                            logger.error("更新异常", e);
                        }
                        return null;
                    }
                });
                futures.add(future);
            });
        });
        for (int t = 0; t < futures.size(); t++) {
            try {
                futures.get(t).get();
                logger.info("========================同步第{}页完成", t + 1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
