package pool.service.specification;

import pool.dto.ProductQueryDto;
import pool.model.ProviderProductFashion;
import pool.model.ProviderProductFashion_;
import utils.Lang;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryProviderGoodsSpecification extends QuerySpecification<ProviderProductFashion, ProductQueryDto> implements Serializable {

    public QueryProviderGoodsSpecification(ProductQueryDto queryInstance) {
        this(queryInstance, true);
    }

    public QueryProviderGoodsSpecification(ProductQueryDto queryInstance, Boolean ignoreNull) {
        super(queryInstance, ignoreNull);
        ignoreNullExcluded.add(ProviderProductFashion_.id);
    }

    public QueryProviderGoodsSpecification(ProductQueryDto queryInstance, Boolean ignoreNull, List<SingularAttribute> ignoreNullExcluded) {
        super(queryInstance, ignoreNull, ignoreNullExcluded);
    }

    @Override
    public Predicate toPredicate(Root<ProviderProductFashion> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {

        List<Predicate> predicates = new ArrayList<>();
        /** =================================== 修改 增加部分查询参数 START=============================================*/

        /**  storeId */
        if (!Lang.isEmpty(super.getQueryInstance().getStoreId())) {//查询必带属性
            predicates.add(criteriaBuilder.equal(root.get(ProviderProductFashion_.storeId), super.getQueryInstance().getStoreId()));
            //根据 storeId 查询 供应商 名字
        }
        /**  getSku */
        if (!Lang.isEmpty(super.getQueryInstance().getProductSku())) {
            predicates.add(criteriaBuilder.equal(root.get(ProviderProductFashion_.sku), super.getQueryInstance().getProductSku()));
        }
        /**  商品名称 */
        if (!Lang.isEmpty(super.getQueryInstance().getProductName())) {
            predicates.add(criteriaBuilder.like(root.get(ProviderProductFashion_.name), "%" + super.getQueryInstance().getProductName() + "%"));
        }
        /**  商品上下架状态 */
        if (!Lang.isEmpty(super.getQueryInstance().getProviderSaleStatus())) {
            //如果是全部的话，去掉以下条件
            if (!(-1 == super.getQueryInstance().getProviderSaleStatus())) {
                //未上架判断
                if (-2 == super.getQueryInstance().getProviderSaleStatus()) {
                    predicates.add(criteriaBuilder.notEqual(root.get(ProviderProductFashion_.providerSaleStatus), 1));
                } else {
                    predicates.add(criteriaBuilder.equal(root.get(ProviderProductFashion_.providerSaleStatus), super.getQueryInstance().getProviderSaleStatus()));
                }
            }
        }
        /**  商品分类 */
        if (!Lang.isEmpty(super.getQueryInstance().getCategoryId())) {

            predicates.add(criteriaBuilder.equal(root.get(ProviderProductFashion_.categoryId), super.getQueryInstance().getCategoryId()));
        }
        /**  商品品牌名称 模糊查询 */
        if (!Lang.isEmpty(super.getQueryInstance().getProductBrand())) {

            predicates.add(criteriaBuilder.like(root.get(ProviderProductFashion_.brandName), "%" + super.getQueryInstance().getProductBrand() + "%"));
        }

        /** =================================== 修改 增加部分查询参数 END=============================================*/
        //添加isDelete=false的限制
        predicates.add(criteriaBuilder.equal(root.get(ProviderProductFashion_.isDelete), false)); //逻辑删除 true：删除，false：未删除

        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        //return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }


}
