/*
 * Decompiled with CFR 0.152.
 */
package pool.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ProviderPoolLogAspect {
    @Pointcut(value="execution(* pool.service.apiImpl..*.*(..)) && !execution(* pool.service.apiImpl.providermanager.brandmanager..*.*(..))")
    public void logService() {
    }

    @Before(value="logService()")
    public void beforeLog(JoinPoint joinPoint) throws Exception {
        Logger logger = LoggerFactory.getLogger(Class.forName(joinPoint.getSignature().getDeclaringTypeName()));
        String class_method = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName();
        logger.info("\u8c03\u7528\u63a5\u53e3\uff1a" + class_method);
        logger.info("before:------------------requestParams : " + Arrays.toString(joinPoint.getArgs()));
    }

    @AfterReturning(returning="ret", pointcut="logService()")
    public void afterLog(JoinPoint joinPoint, Object ret) throws Exception {
        Logger logger = LoggerFactory.getLogger(Class.forName(joinPoint.getSignature().getDeclaringTypeName()));
        String str = JSON.toJSONString((Object)ret, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        logger.info("after:------------------responseBody : " + str);
    }
}

