/*
 * Decompiled with CFR 0.152.
 */
package pool.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.List;
import localstore.dto.LocalStoreOrderVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pool.api.ProviderGoodsApi;
import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperLowerDto;
import pool.dto.ProductModelDto;
import pool.dto.ProductQueryDto;
import pool.dto.ProviderGoodsDto;
import pool.dto.ProviderGoodsPrice;
import pool.dto.ProviderGoodsStatus;
import pool.dto.ProviderGoodsStock;
import pool.service.service.GoodsAutosyncFilterService;
import pool.service.service.ProviderGoodsService;
import pool.vo.GoodsUpperAndLowerVo;
import pool.vo.ProviderGoodsVo;
import pool.vo.UpdateProviderGoodsVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.PageVo;

@MotanService
public class ProviderGoodsApiImpl
implements ProviderGoodsApi {
    private static final Logger log = LoggerFactory.getLogger(ProviderGoodsApiImpl.class);
    private static int LIMIT = 10000;
    @Autowired
    private ProviderGoodsService providerGoodsService;
    @Autowired
    private ProviderGoodsService providerProductService;
    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;
    private static final Logger logger = LoggerFactory.getLogger(ProviderGoodsApiImpl.class);

    public BaseResponse<PageVo<ProviderGoodsVo>> queryProviderGoodsPage(ProductQueryDto productQueryDto) {
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u5546\u54c1\u5217\u8868\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)productQueryDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = this.providerGoodsService.queryProviderGoodsPage(productQueryDto);
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u5546\u54c1\u5217\u8868\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return baseResponse;
    }

    public BaseResponse<ProviderGoodsVo> queryProviderGoods(String sku, String storeId) {
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u5355\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{},{}", (Object)sku, (Object)storeId);
        BaseResponse baseResponse = this.providerGoodsService.queryProviderGoods(sku, storeId);
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u5355\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return baseResponse;
    }

    public BaseResponse<String> saveProviderGoods(ProviderGoodsDto providerGoodsDto) {
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u4fdd\u5b58\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)providerGoodsDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = this.providerGoodsService.saveProviderGoods(providerGoodsDto);
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u4fdd\u5b58\u5546\u54c1\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return baseResponse;
    }

    public BaseResponse<String> updateProviderGoods(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse = this.providerGoodsService.updateProviderGoods(providerGoodsDto);
        return baseResponse;
    }

    public BaseResponse modifyGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId) {
        BaseResponse baseResponse = this.providerGoodsService.updateGoodsStatus(providerGoodsStatusList, storeId);
        return baseResponse;
    }

    public BaseResponse modifyGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId) {
        BaseResponse baseResponse = this.providerGoodsService.updateGoodsPrice(providerGoodsPriceList, storeId);
        return baseResponse;
    }

    public BaseResponse modifyGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId) {
        BaseResponse baseResponse = this.providerGoodsService.updateGoodsStock(providerGoodsStockList, storeId);
        return baseResponse;
    }

    public BaseResponse queryGoods(List<String> skus, String storeId) {
        BaseResponse baseResponse = this.providerGoodsService.queryGoods(skus, storeId);
        return baseResponse;
    }

    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo) {
        BaseResponse baseResponse = this.providerGoodsService.occupyStock(localStoreOrderVo);
        return baseResponse;
    }

    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        return this.providerGoodsService.cancelOccupyStock(thrOrderNo, storedId);
    }

    public BaseResponse<List<ProviderGoodsDto>> updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo) {
        BaseResponse baseResponse = this.providerGoodsService.updateProviderProduct(updateProviderGoodsVo);
        return baseResponse;
    }

    public BaseResponse<String> saveProviderProduct(ProductModelDto productModel, List<ProviderGoodsDto> providerGoodsDtos) {
        logger.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u4fdd\u5b58\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(providerGoodsDtos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = this.providerGoodsService.saveProviderProduct(productModel, providerGoodsDtos);
        return baseResponse;
    }

    public ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId) {
        logger.info("\u5546\u54c1\u7ba1\u7406\uff0c\u67e5\u8be2\u5355\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{},{}", (Object)sku, (Object)storeId);
        ProviderGoodsDto goodsDto = this.providerGoodsService.queryProviderGoodsDto(sku, storeId);
        logger.info("\u5546\u54c1\u7ba1\u7406\uff0c\u67e5\u8be2\u5355\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)goodsDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return goodsDto;
    }

    @Transactional
    public BaseResponse<List<String>> preferredOrIsUp(GoodsUpperAndLowerVo goodsUpperAndLowerVo) {
        long timerGetSimilarProduct = System.currentTimeMillis();
        if (!Lang.isEmpty((Object)goodsUpperAndLowerVo.getIsAllGoods())) {
            goodsUpperAndLowerVo.getGoodsUpperLowerDtos().clear();
            BaseResponse baseResponse = this.providerGoodsService.findGoodsUpperAndLowersByQuery(goodsUpperAndLowerVo.getGoodsUpperAndLowerQueryDto());
            if (baseResponse.isSuccess()) {
                int size = ((List)baseResponse.getResult()).size();
                if (((List)baseResponse.getResult()).size() > LIMIT) {
                    size = LIMIT;
                }
                for (int i = 0; i < size; ++i) {
                    if (Lang.isEmpty(((List)baseResponse.getResult()).get(i)) || Lang.isEmpty((Object)((GoodsUpperAndLowerDto)((List)baseResponse.getResult()).get(i)).getSku())) continue;
                    GoodsUpperLowerDto goodsUpperLowerDto = new GoodsUpperLowerDto();
                    goodsUpperLowerDto.setSku(((GoodsUpperAndLowerDto)((List)baseResponse.getResult()).get(i)).getSku());
                    goodsUpperLowerDto.setStoreId(((GoodsUpperAndLowerDto)((List)baseResponse.getResult()).get(i)).getStoreId());
                    goodsUpperAndLowerVo.getGoodsUpperLowerDtos().add(goodsUpperLowerDto);
                }
            }
        }
        BaseResponse response = this.providerGoodsService.preferredOrIsUpByThread(goodsUpperAndLowerVo);
        log.info(" type {} \u8017\u65f6 {} ms , \u7ed3\u679c {} ", new Object[]{goodsUpperAndLowerVo.getOpertionCode(), System.currentTimeMillis() - timerGetSimilarProduct, response.toString()});
        return response;
    }

    public List<ProviderGoodsDto> queryProviderGoodsDtoList(String modelSku, String storeId) {
        logger.info("\u5546\u54c1\u7ba1\u7406,\u67e5\u8be2\u591a\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{},{}", (Object)modelSku, (Object)storeId);
        List goodsDtos = this.providerGoodsService.queryProviderGoodsDtoList(modelSku, storeId);
        logger.info("\u5546\u54c1\u7ba1\u7406\uff0c\u67e5\u8be2\u591a\u4e2a\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)goodsDtos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return goodsDtos;
    }

    public BaseResponse deleteProviderGoodsBatch(List<String> skus, String storeId) {
        return this.providerGoodsService.deleteProviderGoodsBatch(skus, storeId);
    }

    public List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, Boolean isDelete) {
        return this.providerGoodsService.findByModelSkuAndStoreIdAndIsDelete(modelSku, storeId, isDelete);
    }

    public void updateBrandInfo(String id, String brandName, String brandId) {
        this.providerGoodsService.updateBrandInfo(id, brandName, brandId);
    }
}

