/*
 * Decompiled with CFR 0.152.
 */
package pool.service.listeners;

import goods.vo.GoodsStateVo;
import goods.vo.PriceUpdateMessageVo;
import goods.vo.ProductAddMessageVo;
import goods.vo.ProductDeleteMessageVo;
import goods.vo.ProductDetailUpdateMessageVo;
import goods.vo.SkuStatusUpdateMessageVo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;
import pool.dto.ProviderGoodsDto;
import pool.dto.ProviderGoodsStatus;
import pool.model.ProviderGoodsMqLog;
import pool.model.repository.ProviderGoodsMqLogRepos;
import pool.service.service.ProviderGoodsService;
import pool.service.service.StoreService;
import pool.vo.ProductReturnVo;
import pool.vo.ProductUpdateResult;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

@Component
public class MqHandleListener {
    private static final Logger log = LoggerFactory.getLogger(MqHandleListener.class);
    @Autowired
    StoreService storeService;
    @Autowired
    ProviderGoodsService providerGoodsService;
    @Autowired
    ProviderGoodsMqLogRepos providerGoodsMqLogRepos;

    @JmsListener(destination="${provider.updatePrice.queue}", containerFactory="queueListenerFactory")
    public void updatePrice(PriceUpdateMessageVo priceUpdateMessageVo) {
        ProductUpdateResult pur;
        StoreDto storeDto = this.storeService.getStoreByCode(priceUpdateMessageVo.getStoreCode());
        List providerGoodsPrices = priceUpdateMessageVo.getProviderGoodsPrices();
        log.info("providerPool\u5904\u7406\u4f9b\u5e94\u5546\u5546\u54c1\u4ef7\u683c\u6d88\u606f\uff1a{},===={}", (Object)priceUpdateMessageVo.getStoreCode(), (Object)providerGoodsPrices.toString());
        BaseResponse rsp = this.providerGoodsService.updateGoodsPrice(providerGoodsPrices, storeDto.getId());
        if (!(Lang.isEmpty((Object)rsp.getResult()) || Lang.isEmpty((Object)(pur = (ProductUpdateResult)rsp.getResult())) || Lang.isEmpty((Object)pur.getFailList()))) {
            for (int i = 0; i < pur.getFailList().size(); ++i) {
                ProductReturnVo prv = (ProductReturnVo)pur.getFailList().get(i);
                log.info("\u4ef7\u683c\u53d8\u66f4\u5904\u7406\u5931\u8d25\u7684sku\u6570\u636e\uff1a{}===={}", (Object)priceUpdateMessageVo.getStoreCode(), (Object)prv.getSku());
                this.addProviderGoodsMqLog(prv.getSku(), "updatePrice", priceUpdateMessageVo.getStoreCode());
            }
        }
    }

    @JmsListener(destination="${provider.productDelete.queue}", containerFactory="queueListenerFactory")
    public void productDelete(ProductDeleteMessageVo productDeleteMessageVo) {
        StoreDto storeDto = this.storeService.getStoreByCode(productDeleteMessageVo.getStoreCode());
        List skus = productDeleteMessageVo.getSkuIds();
        log.info("providerPool\u5904\u7406\u4f9b\u5e94\u5546\u5220\u9664\u6d88\u606f\uff1a{},===={}", (Object)productDeleteMessageVo.getStoreCode(), (Object)skus.toString());
        BaseResponse rsp = this.providerGoodsService.deleteProviderGoodsBatch(skus, storeDto.getId());
        if (!rsp.isSuccess()) {
            for (int i = 0; i < skus.size(); ++i) {
                log.info("\u5546\u54c1\u5220\u9664\u5904\u7406\u5931\u8d25\u7684sku\u6570\u636e\uff1a{}===={}", (Object)productDeleteMessageVo.getStoreCode(), skus.get(i));
                this.addProviderGoodsMqLog((String)skus.get(i), "productDelete", productDeleteMessageVo.getStoreCode());
            }
        }
    }

    @JmsListener(destination="${provider.productAdd.queue}", containerFactory="queueListenerFactory")
    public void productAdd(ProductAddMessageVo productAddMessageVo) {
        StoreDto storeDto = this.storeService.getStoreByCode(productAddMessageVo.getStoreCode());
        ProviderGoodsDto providerGoodsDto = productAddMessageVo.getProviderGoodsDto();
        providerGoodsDto.setStoreId(storeDto.getId());
        BaseResponse rsp = this.providerGoodsService.saveProviderGoods(providerGoodsDto);
        if (!rsp.isSuccess()) {
            this.addProviderGoodsMqLog(providerGoodsDto.getSku(), "productAdd", productAddMessageVo.getStoreCode());
        }
    }

    @JmsListener(destination="${provider.productDetail.queue}", containerFactory="queueListenerFactory")
    public void productDetail(ProductDetailUpdateMessageVo productDetailUpdateMessageVo) {
        StoreDto storeDto = this.storeService.getStoreByCode(productDetailUpdateMessageVo.getStoreCode());
        ProviderGoodsDto providerGoodsDto = productDetailUpdateMessageVo.getProviderGoodsDto();
        providerGoodsDto.setStoreId(storeDto.getId());
        log.info("providerPool\u5904\u7406\u4f9b\u5e94\u5546\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u6d88\u606f\uff1amessageId:{}===={}===={}", new Object[]{productDetailUpdateMessageVo.getMessageId(), productDetailUpdateMessageVo.getStoreCode(), providerGoodsDto.toString()});
        BaseResponse rsp = this.providerGoodsService.updateProviderGoods(providerGoodsDto);
        if (!rsp.isSuccess()) {
            this.addProviderGoodsMqLog(providerGoodsDto.getSku(), "productDetail", productDetailUpdateMessageVo.getStoreCode());
        }
    }

    @JmsListener(destination="${provider.updateSkuStatus.queue}", containerFactory="queueListenerFactory")
    public void updateSkuStatus(SkuStatusUpdateMessageVo skuStatusUpdateMessageVo) {
        ProductUpdateResult pur;
        StoreDto storeDto = this.storeService.getStoreByCode(skuStatusUpdateMessageVo.getStoreCode());
        List goodsStateVos = skuStatusUpdateMessageVo.getGoodsStateVoList();
        ArrayList<ProviderGoodsStatus> pgss = new ArrayList<ProviderGoodsStatus>();
        for (int i = 0; i < goodsStateVos.size(); ++i) {
            ProviderGoodsStatus pgs = new ProviderGoodsStatus();
            pgs.setSku(((GoodsStateVo)goodsStateVos.get(i)).getSku());
            pgs.setStatus(((GoodsStateVo)goodsStateVos.get(i)).getState());
            pgss.add(pgs);
        }
        log.info("providerPool\u5904\u7406\u4f9b\u5e94\u5546\u4e0a\u4e0b\u67b6\u6d88\u606f\uff1astoreCode:{}===={}", (Object)skuStatusUpdateMessageVo.getStoreCode(), (Object)((Object)pgss).toString());
        BaseResponse rsp = this.providerGoodsService.updateGoodsStatus(pgss, storeDto.getId());
        if (!(Lang.isEmpty((Object)rsp.getResult()) || Lang.isEmpty((Object)(pur = (ProductUpdateResult)rsp.getResult())) || Lang.isEmpty((Object)pur.getFailList()))) {
            for (int i = 0; i < pur.getFailList().size(); ++i) {
                ProductReturnVo prv = (ProductReturnVo)pur.getFailList().get(i);
                log.info("\u4e0a\u4e0b\u67b6\u5904\u7406\u5931\u8d25\u7684sku\u6570\u636e\uff1a{}===={}", (Object)skuStatusUpdateMessageVo.getStoreCode(), (Object)prv.getSku());
                this.addProviderGoodsMqLog(prv.getSku(), "updateSkuStatus", skuStatusUpdateMessageVo.getStoreCode());
            }
        }
    }

    private void addProviderGoodsMqLog(String sku, String type, String providerName) {
        try {
            ProviderGoodsMqLog providerGoodsMqLog = new ProviderGoodsMqLog();
            providerGoodsMqLog.setSku(sku);
            providerGoodsMqLog.setType(type);
            providerGoodsMqLog.setProvidername(providerName);
            CompletableFuture.runAsync(() -> this.providerGoodsMqLogRepos.save((Object)providerGoodsMqLog));
        }
        catch (Exception e) {
            log.error("SKU {} --- type {} --- \u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38", new Object[]{sku, type, e});
        }
    }
}

