/*
 * Decompiled with CFR 0.152.
 */
package pool.service.listeners;

import goods.vo.PriceUpdateMessageVo;
import goods.vo.ProductAddMessageVo;
import goods.vo.ProductDeleteMessageVo;
import goods.vo.ProductDetailUpdateMessageVo;
import goods.vo.SkuBatchUpdateStatusVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;
import pool.dto.ProviderGoodsDto;
import pool.dto.ProviderGoodsPrice;

@Component
public class MqHandleProducer {
    private static final Logger log = LoggerFactory.getLogger(MqHandleProducer.class);
    @Autowired
    JmsTemplate jmsTemplate;
    @Value(value="${taiping.updatePrice.queue}")
    private String taipingUpdatePriceQueue;
    @Value(value="${taiping.productDelete.queue}")
    private String taipingProductDeleteQueue;
    @Value(value="${taiping.productAdd.queue}")
    private String taipingProductAddQueue;
    @Value(value="${taiping.productDetail.queue}")
    private String taipingProductDetailQueue;
    @Value(value="${taiping.updateSkuStatusUp.queue}")
    private String taipingUpdateSkuStatusUpQueue;
    @Value(value="${taiping.updateSkuStatusDown.queue}")
    private String taipingUpdateSkuStatusDownQueue;

    public void sendPriceUpdateMessage(List<ProviderGoodsPrice> providerGoodsPrices, String storeCode) {
        PriceUpdateMessageVo pumv = new PriceUpdateMessageVo();
        pumv.setProviderGoodsPrices(providerGoodsPrices);
        pumv.setStoreCode(storeCode);
        log.info("\u4ef7\u683c\u53d8\u66f4\u6d88\u606f\u5904\u7406\uff0c\u5411\u91d1\u670d\u5546\u54c1\u6c60\u63a8\u9001,\u4f9b\u5e94\u5546\uff1a{}=====sku:{}", (Object)storeCode, (Object)providerGoodsPrices.toString());
        this.jmsTemplate.convertAndSend(this.taipingUpdatePriceQueue, (Object)pumv);
    }

    public void sendProductDetailMessage(ProviderGoodsDto providerGoodsDto, String storeCode) {
        ProductDetailUpdateMessageVo pdumv = new ProductDetailUpdateMessageVo();
        pdumv.setProviderGoodsDto(providerGoodsDto);
        pdumv.setStoreCode(storeCode);
        log.info("\u5546\u54c1\u8be6\u60c5\u53d8\u66f4\u6d88\u606f\u5904\u7406\uff0c\u5411\u91d1\u670d\u5546\u54c1\u6c60\u63a8\u9001,\u4f9b\u5e94\u5546\uff1a{}=====sku:{}====detail\uff1a{}", new Object[]{storeCode, providerGoodsDto.getSku(), providerGoodsDto.toString()});
        this.jmsTemplate.convertAndSend(this.taipingProductDetailQueue, (Object)pdumv);
    }

    public void sendProductDeleteMessage(List<String> skus, String storeCode) {
        ProductDeleteMessageVo pdmv = new ProductDeleteMessageVo();
        pdmv.setSkuIds(skus);
        pdmv.setStoreCode(storeCode);
        log.info("\u5546\u54c1\u5220\u9664\u6d88\u606f\u5904\u7406\uff0c\u5411\u91d1\u670d\u5546\u54c1\u6c60\u63a8\u9001,\u4f9b\u5e94\u5546\uff1a{}=====skus\uff1a{}", (Object)storeCode, (Object)skus.toString());
        this.jmsTemplate.convertAndSend(this.taipingProductDeleteQueue, (Object)pdmv);
    }

    public void sendSkuUpMessage(List<String> skus, String storeId, String organizationCode) {
        SkuBatchUpdateStatusVo skuBatchUpdateStatusVo = new SkuBatchUpdateStatusVo();
        skuBatchUpdateStatusVo.setStoreId(storeId);
        skuBatchUpdateStatusVo.setOrganizationCode(organizationCode);
        skuBatchUpdateStatusVo.setSkus(skus);
        this.jmsTemplate.convertAndSend(this.taipingUpdateSkuStatusUpQueue, (Object)skuBatchUpdateStatusVo);
    }

    public void sendSkuDownMessage(List<String> skus, String storeId) {
        SkuBatchUpdateStatusVo skuBatchUpdateStatusVo = new SkuBatchUpdateStatusVo();
        skuBatchUpdateStatusVo.setStoreId(storeId);
        skuBatchUpdateStatusVo.setSkus(skus);
        this.jmsTemplate.convertAndSend(this.taipingUpdateSkuStatusDownQueue, (Object)skuBatchUpdateStatusVo);
    }

    public void sendProductAddMessage(ProviderGoodsDto providerGoodsDto, String storeCode) {
        ProductAddMessageVo pamv = new ProductAddMessageVo();
        pamv.setProviderGoodsDto(providerGoodsDto);
        pamv.setStoreCode(storeCode);
        this.jmsTemplate.convertAndSend(this.taipingProductAddQueue, (Object)pamv);
    }
}

