/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service;

import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryconfigApi;
import goods.dto.product.ProductCategoryConfigDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pool.model.ProviderProduct;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductBrandRepos;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.OrganizationApiStub;
import pool.service.service.StoreService;
import utils.Lang;

@Service
public class GoodsAutosyncFilterService {
    private static final Logger log = LoggerFactory.getLogger(GoodsAutosyncFilterService.class);
    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;
    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;
    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    OrganizationApiStub organizationApiStub;
    @MotanReferer
    ProductCategoryconfigApi productCategoryconfigApi;
    @Autowired
    StoreService storeService;
    static String UNINOGIFT = "uninogift";

    public Map autoUpCategoryBrandMappingFilter(List<String> skus, String storeId) {
        HashMap rsData = new HashMap();
        ArrayList<String> upSuccessMsgList = new ArrayList<String>();
        ArrayList<String> upFailList = new ArrayList<String>();
        for (int i = 0; i < skus.size(); ++i) {
            List goodsList = this.providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(skus.get(i), storeId, false);
            if (!Lang.isEmpty((Object)goodsList)) {
                ProviderProductFashion providerProductFashion = (ProviderProductFashion)goodsList.get(0);
                ProviderProduct model = providerProductFashion.getProviderProduct();
                if (Lang.isEmpty((Object)model) || Lang.isEmpty((Object)model.getCategoryId()) || Lang.isEmpty((Object)model.getProductBrandId())) {
                    upFailList.add(skus.get(i));
                    log.info("sku:{}\u4e0a\u67b6\uff0c\u5206\u7c7b\u54c1\u724c\u672a\u6620\u5c04,storeId:{}", (Object)skus.get(i), (Object)storeId);
                    continue;
                }
                upSuccessMsgList.add(skus.get(i));
                continue;
            }
            upFailList.add(skus.get(i));
            log.info("sku:{}\u4e0a\u67b6\uff0c\u5546\u54c1\u4e0d\u5b58\u5728,storeId:{}", (Object)skus.get(i), (Object)storeId);
        }
        rsData.put("upSuccessMsgList", upSuccessMsgList);
        rsData.put("upFailList", upFailList);
        return rsData;
    }

    public Map autoUpCategoryOrgUpFilter(String sku, String storeId, List<OrganizationDto> orgs) {
        HashMap rsData = new HashMap();
        List goodsList = this.providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(sku, storeId, false);
        ProviderProduct model = ((ProviderProductFashion)goodsList.get(0)).getProviderProduct();
        ArrayList<String> organizationList = new ArrayList<String>();
        for (OrganizationDto org : orgs) {
            if (UNINOGIFT.equals(org.getOrgCode())) continue;
            ProductCategoryConfigDto pcc = this.productCategoryconfigApi.findByProductCategoryIdAndOrganizationId(model.getCategoryId(), org.getId());
            if (Lang.isEmpty((Object)pcc) || Lang.isEmpty((Object)pcc.getIsUp()) || !pcc.getIsUp().booleanValue()) {
                log.info("sku:{}\u4e0a\u67b6\uff0c\u4e09\u7ea7\u5206\u7c7b\uff1a{}\u672a\u5728\uff1a{}\u4e0a\u67b6,storeId:{}", new Object[]{sku, model.getCategoryId(), org.getOrgCode(), storeId});
                continue;
            }
            organizationList.add(org.getOrgCode());
        }
        rsData.put("organizationList", organizationList);
        return rsData;
    }
}

